/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.OneWaySendMode;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Validation;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Fact;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IFlowControl
extends Element {
    public static final ElementType TYPE = new ElementType(IFlowControl.class);
    @Type(base=Boolean.class)
    @XmlBinding(path="flow-control-params/flow-control-enabled")
    @Label(standard="Enable flow control")
    @DefaultValue(text="true")
    @Documentation(content="Specifies whether or not a producer created using a connection factory allows flow control. If true, the associated message producers will be slowed down if a JMS server or a destination reaches its specified upper byte or message threshold.")
    public static final ValueProperty PROP_FLOW_CONTROL_ENABLED = new ValueProperty(TYPE, "FlowControlEnabled");
    @Type(base=Integer.class)
    @XmlBinding(path="flow-control-params/flow-minimum")
    @Label(standard="flow minimum")
    @DefaultValue(text="50")
    @NumericRange(min="1")
    @Enablement(expr="${ FlowControlEnabled }")
    @Validation(rule="${ FlowMinimum <= FlowMaximum }", message="Must be less than or equal to maximum flow.")
    @Fact(statement="Must be less than or equal to maximum flow.")
    @Documentation(content="The minimum number of messages per second allowed for a producer that is experiencing a threshold condition. This is the lower boundary of a producer's flow limit. That is, WebLogic JMS will not further slow down a producer whose message flow limit is at its FlowMinimum.[pbr/]When a producer is flow-controlled, it will never be required to go slower than FlowMinimum messages per second.")
    public static final ValueProperty PROP_FLOW_MINIMUM = new ValueProperty(TYPE, "FlowMinimum");
    @Type(base=Integer.class)
    @XmlBinding(path="flow-control-params/flow-maximum")
    @Label(standard="flow maximum")
    @DefaultValue(text="500")
    @NumericRange(min="1")
    @Enablement(expr="${ FlowControlEnabled }")
    @Validation(rule="${ FlowMinimum <= FlowMaximum }", message="Must be greater than or equal to minimum flow.")
    @Fact(statement="Must be greater than or equal to minimum flow.")
    @Documentation(content="The maximum number of messages per second allowed for a producer that is experiencing a threshold condition. When a producer is flow-controlled, it will never be allowed to go faster than the FlowMaximum messages per second.[pbr/]If a producer is not currently limiting its flow when a threshold condition is reached, the initial flow limit for that producer is set to FlowMaximum. If a producer is already limiting its flow when a threshold condition is reached (the flow limit is less than FlowMaximum), then the producer will continue at its current flow limit until the next time the flow is evaluated.[pbr/]Note: Once a threshold condition has subsided, the producer is not permitted to ignore its flow limit. If its flow limit is less than the FlowMaximum, then the producer must gradually increase its flow to the FlowMaximum each time the flow is evaluated. When the producer finally reaches the FlowMaximum, it can then ignore its flow limit and send without limiting its flow.")
    public static final ValueProperty PROP_FLOW_MAXIMUM = new ValueProperty(TYPE, "FlowMaximum");
    @Type(base=Integer.class)
    @XmlBinding(path="flow-control-params/flow-interval")
    @Label(standard="flow interval (secs)")
    @DefaultValue(text="60")
    @NumericRange(min="0")
    @Enablement(expr="${ FlowControlEnabled }")
    @Validation(rule="${ FlowSteps <= FlowInterval }", message="Must be greater than or equal to flow steps.")
    @Fact(statement="Must be greater than or equal to flow steps.")
    @Documentation(content="The adjustment period of time, in seconds, when a producer adjusts its flow from the FlowMaximum number of messages to the FlowMinimum amount, or vice versa.[pbr/]When a producer is flow-controlled, it is slowed down from its FlowMaximum to its FlowMinimum over the specified FlowInterval amount of seconds.")
    public static final ValueProperty PROP_FLOW_INTERVAL = new ValueProperty(TYPE, "FlowInterval");
    @Type(base=Integer.class)
    @XmlBinding(path="flow-control-params/flow-steps")
    @Label(standard="flow steps")
    @DefaultValue(text="10")
    @NumericRange(min="1")
    @Enablement(expr="${ FlowControlEnabled }")
    @Validation(rule="${ FlowSteps <= FlowInterval }", message="Must be less than or equal to flow interval.")
    @Fact(statement="Must be less than or equal to flow interval.")
    @Documentation(content="The number of steps used when a producer is adjusting its flow from the Flow Maximum amount of messages to the Flow Minimum amount, or vice versa. Specifically, the Flow Interval adjustment period is divided into the number of Flow Steps (for example, 60 seconds divided by 6 steps is 10 seconds per step).[pbr/]Also, the movement (i.e., the rate of adjustment) is calculated by dividing the difference between the Flow Maximum and the Flow Minimum into steps. At each Flow Step, the flow is adjusted upward or downward, as necessary, based on the current conditions, as follows:[pbr/]* The downward movement (the decay) is geometric over the specified period of time (Flow Interval) and according to the specified number of Flow Steps. (For example, 100, 50, 25, 12.5)[pbr/]* The movement upward is linear. The difference is simply divided by the number of steps.")
    public static final ValueProperty PROP_FLOW_STEPS = new ValueProperty(TYPE, "FlowSteps");
    @Type(base=OneWaySendMode.class)
    @XmlBinding(path="flow-control-params/one-way-send-mode")
    @Label(standard="one way send mode")
    @DefaultValue(text="disabled")
    @Documentation(content="Specifies whether or not message producers created using this connection factory are allowed to send messages one way only to improve typical nonpersistent, nontransactional messaging performance. When enabled, the associated queue senders and/or topic publishers can send messages without internally waiting for a response from the target destination's host JMS server.[pbr/]Sending messages one way is supported only when the connection factory hosting the producer and the JMS server hosting the target destination are targeted to the same Oracle WebLogic Server instance. In addition, one-way sends are not supported for higher quality of service (QOS) features, such as XA, transacted sessions, persistent messaging, unit of order, unit of work, distributed destinations, and client-side store-and-forward. If the producer and target destination are in separate domains, or if any of these higher QOS features are detected, then the one-way mode setting will be ignored and standard two-way sends will be used instead.[ul][li]Disabled: One-way send is disabled.[/li][li]Enabled: One-way send is permitted for queue senders or topic publishers.[/li][li]Topic Only: Only topic publishers are permitted to do one-way sends.[/li][/ul][br/]Notes: One-way message sends are disabled if your connection factory is configured with XA Connection Factory Enabled. This setting disables one-way sends whether or not the sender actually uses transactions.[pbr/]To benefit from one-way performance, the default OneWaySendWindowSize value must also be configured higher. After every OneWaySendWindowSize - 1 number of messages, a two-way is used instead of a one-way, so all messages are actually two-way when the OneWaySendWindowSize = 1.")
    public static final ValueProperty PROP_ONE_WAY_SEND_MODE = new ValueProperty(TYPE, "OneWaySendMode");
    @Type(base=Integer.class)
    @NamedValues(arbitraryValueLabel="one way send window size", defaultArbitraryValue="10", namedValues={@NamedValues.NamedValue(value="1", label="all messages are two way")})
    @XmlBinding(path="flow-control-params/one-way-send-window-size")
    @Label(standard="one way send window size")
    @DefaultValue(text="1")
    @NumericRange(min="1")
    @Enablement(expr="${ OneWaySendMode == 'enabled' || OneWaySendMode == 'topicOnly' }")
    @Documentation(content="Specifies the maximum number of sent messages per window when OneWaySendMode is set to allow queue senders and/or topic publishers to make one-way sends. The window size determines when a two-way message is required to regulate the producer before it can continue making additional one-way sends.[pbr/]To benefit from one-way performance, the default OneWaySendWindowSize value must be configured higher in addition to enabling one-way sends. After every OneWaySendWindowSize - 1 number of messages, a two-way is used instead of a one-way, so all messages are actually two-way when the OneWaySendWindowSize = 1.")
    public static final ValueProperty PROP_ONE_WAY_SEND_WINDOW_SIZE = new ValueProperty(TYPE, "OneWaySendWindowSize");

    public Value<Boolean> getFlowControlEnabled();

    public void setFlowControlEnabled(String var1);

    public void setFlowControlEnabled(Boolean var1);

    public Value<Integer> getFlowMinimum();

    public void setFlowMinimum(String var1);

    public void setFlowMinimum(Integer var1);

    public Value<Integer> getFlowMaximum();

    public void setFlowMaximum(String var1);

    public void setFlowMaximum(Integer var1);

    public Value<Integer> getFlowInterval();

    public void setFlowInterval(String var1);

    public void setFlowInterval(Integer var1);

    public Value<Integer> getFlowSteps();

    public void setFlowSteps(String var1);

    public void setFlowSteps(Integer var1);

    public Value<OneWaySendMode> getOneWaySendMode();

    public void setOneWaySendMode(String var1);

    public void setOneWaySendMode(OneWaySendMode var1);

    public Value<Integer> getOneWaySendWindowSize();

    public void setOneWaySendWindowSize(String var1);

    public void setOneWaySendWindowSize(Integer var1);
}

