/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.ICommonDistributedDestination;
import oracle.eclipse.tools.weblogic.descriptors.jms.SafExportPolicy;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.JndiNameValidator;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IDistributedDestination
extends ICommonDistributedDestination {
    public static final ElementType TYPE = new ElementType(IDistributedDestination.class);
    @XmlBinding(path="jndi-name")
    @Label(standard="JNDI name")
    @Service(impl=JndiNameValidator.class)
    @Documentation(content="The name used to bind a virtual destination to the JNDI tree. Applications can use the JNDI name to look up the virtual destination.[pbr/]If not specified, then the destination is not bound into the JNDI namespace.")
    public static final ValueProperty PROP_JNDI_NAME = new ValueProperty(TYPE, "JndiName");
    @XmlBinding(path="local-jndi-name")
    @Label(standard="local JNDI name")
    public static final ValueProperty PROP_LOCAL_JNDI_NAME = new ValueProperty(TYPE, "LocalJndiName");
    @Type(base=SafExportPolicy.class)
    @XmlBinding(path="saf-export-policy")
    @Label(standard="SAF export policy")
    @DefaultValue(text="All")
    @Documentation(content="The SAF Export Policy controls which applications can send JMS messages to this destination through Store-and-Forward.[ul][li]All: This destination allows everyone to send JMS messages to it through SAF.[/li][li]None: This destination does not allow anyone to send JMS messages from a remote server to it through SAF.[/li][/ul]")
    public static final ValueProperty PROP_SAF_EXPORT_POLICY = new ValueProperty(TYPE, "SafExportPolicy");

    public Value<String> getJndiName();

    public void setJndiName(String var1);

    public Value<String> getLocalJndiName();

    public void setLocalJndiName(String var1);

    public Value<SafExportPolicy> getSafExportPolicy();

    public void setSafExportPolicy(String var1);

    public void setSafExportPolicy(SafExportPolicy var1);
}

