/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.INamedEntity;
import oracle.eclipse.tools.weblogic.descriptors.jms.KeyType;
import oracle.eclipse.tools.weblogic.descriptors.jms.SortOrder;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.DestinationKeyTypeValidator;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="destination key")
public interface IDestinationKey
extends INamedEntity {
    public static final ElementType TYPE = new ElementType(IDestinationKey.class);
    @XmlBinding(path="property")
    @Label(standard="sort key")
    @DefaultValue(text="JMSMessageID")
    @PossibleValues(values={"JMSMessageID", "JMSTimestamp", "JMSCorrelationID", "JMSPriority", "JMSExpiration", "JMSType", "JMSRedelivered", "JMSDeliveryTime", "JMS_BEA_Size", "JMS_BEA_UnitOfOrder"}, invalidValueSeverity=Status.Severity.OK)
    @Documentation(content="Specifies a message property name or the name of a message header field on which to sort messages. Message header field keys ignore the key type and reference message header fields rather than message properties.")
    public static final ValueProperty PROP_SORT_KEY = new ValueProperty(TYPE, "SortKey");
    @Type(base=KeyType.class)
    @XmlBinding(path="key-type")
    @Label(standard="key type")
    @DefaultValue(text="String")
    @Service(impl=DestinationKeyTypeValidator.class)
    @Documentation(content="The expected property type for this destination key.")
    public static final ValueProperty PROP_KEY_TYPE = new ValueProperty(TYPE, "KeyType");
    @Type(base=SortOrder.class)
    @XmlBinding(path="sort-order")
    @Label(standard="direction")
    @DefaultValue(text="Ascending")
    @Documentation(content="The direction (Ascending or Descending) in which this key will sort messages.")
    public static final ValueProperty PROP_SORT_ORDER = new ValueProperty(TYPE, "SortOrder");

    public Value<String> getSortKey();

    public void setSortKey(String var1);

    public Value<KeyType> getKeyType();

    public void setKeyType(String var1);

    public void setKeyType(KeyType var1);

    public Value<SortOrder> getSortOrder();

    public void setSortOrder(String var1);

    public void setSortOrder(SortOrder var1);
}

