/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.AttachSenderCredentialsPolicy;
import oracle.eclipse.tools.weblogic.descriptors.jms.HandlingPolicy;
import oracle.eclipse.tools.weblogic.descriptors.jms.IDestinationKeyReference;
import oracle.eclipse.tools.weblogic.descriptors.jms.SafExportPolicy;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.DestinationKeyValidator;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Validation;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Fact;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

public interface IDestinationBase
extends Element {
    public static final ElementType TYPE = new ElementType(IDestinationBase.class);
    @Label(standard="destination keys")
    @Type(base=IDestinationKeyReference.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="destination-key", type=IDestinationKeyReference.class)})
    @Service(impl=DestinationKeyValidator.class)
    @PossibleValues(property="/DestinationKeys/Name")
    @MustExist
    @Documentation(content="A list of potential destination keys for sorting the messages that arrive on a JMS destination. The default sort order is strictly FIFO.[pbr/]The keys are ordered from most significant to least significant.")
    public static final ListProperty PROP_DESTINATION_KEYS = new ListProperty(TYPE, "DestinationKeys");
    @Type(base=AttachSenderCredentialsPolicy.class)
    @XmlBinding(path="attach-sender")
    @Label(standard="attach sender credentials policy")
    @DefaultValue(text="supports")
    @Documentation(content="Specifies whether or not messages landing on this destination should attach the credential of the sending user.[ul][li]Attach if Requested: The JMSXUserID property is set with the security principal of the sending user if requested. The sender can request its identity to be attached to its messages by using a connection factory with the AttachJMSXUserID security property enabled.[/li][li]Never Attach: The JMSXUserID property is never set with the security principal of the sending user no matter how the AttachJMSXUserID property is configured on connection factories.[/li][li]Always Attach: The JMSXUserID property is always set with the security principal of the sending user no matter how the AttachJMSXUserID property is configured on connection factories.[/li][/ul]")
    public static final ValueProperty PROP_ATTACH_SENDER_CREDENTIALS_POLICY = new ValueProperty(TYPE, "AttachSenderCredentialsPolicy");
    @Type(base=Boolean.class)
    @XmlBinding(path="production-paused-at-startup")
    @Label(standard="pause message production at startup")
    @DefaultValue(text="false")
    @Documentation(content="Specifies whether or not new message production is paused on a destination at startup.")
    public static final ValueProperty PROP_PRODUCTION_PAUSED_AT_STARTUP = new ValueProperty(TYPE, "ProductionPausedAtStartup");
    @Type(base=Boolean.class)
    @XmlBinding(path="insertion-paused-at-startup")
    @Label(standard="pause message insertion at startup")
    @DefaultValue(text="false")
    @Documentation(content="Specifies whether or not new message insertion is paused on a destination at startup.")
    public static final ValueProperty PROP_INSERTION_PAUSED_AT_STARTUP = new ValueProperty(TYPE, "InsertionPausedAtStartup");
    @Type(base=Boolean.class)
    @XmlBinding(path="consumption-paused-at-startup")
    @Label(standard="pause message consumption at startup")
    @DefaultValue(text="false")
    @Documentation(content="Specifies whether or not consumption is paused on a destination at startup.")
    public static final ValueProperty PROP_CONSUMPTION_PAUSED_AT_STARTUP = new ValueProperty(TYPE, "ConsumptionPausedAtStartup");
    @Type(base=Integer.class)
    @XmlBinding(path="maximum-message-size")
    @Label(standard="maximum message size")
    @NumericRange(min="0")
    @DefaultValue(text="max-int")
    @Documentation(content="The maximum size of a message that is accepted from producers on this destination.")
    public static final ValueProperty PROP_MAXIMUM_MESSAGE_SIZE = new ValueProperty(TYPE, "MaximumMessageSize");
    @XmlBinding(path="quota")
    @Label(standard="quota")
    @PossibleValues(property="/Quotas/Name")
    @Documentation(content="A Quota controls the allotment of system resources available to destinations.")
    public static final ValueProperty PROP_QUOTA = new ValueProperty(TYPE, "Quota");
    @Type(base=Boolean.class)
    @XmlBinding(path="default-unit-of-order")
    @Label(standard="auto generate unit-of-order name")
    @DefaultValue(text="false")
    @Documentation(content="Specifies whether or not Oracle WebLogic Server creates a system-generated unit-of-order name that is statistically unique for a destination. Any message arriving at this destination that does not already belong to a unit-of-order is assigned this default name.")
    public static final ValueProperty PROP_DEFAULT_UNIT_OF_ORDER = new ValueProperty(TYPE, "DefaultUnitOfOrder");
    @Type(base=SafExportPolicy.class)
    @XmlBinding(path="saf-export-policy")
    @Label(standard="SAF export policy")
    @DefaultValue(text="All")
    @Documentation(content="Specifies whether or not a user can send messages to a destination using Store-and-Forward.[ul][li]All: All users can send messages to this destination using Store-and-Forward.[/li][li]None:Remote users cannot send messages to a destination using Store-and-Forward.[/li][/ul]")
    public static final ValueProperty PROP_SAF_EXPORT_POLICY = new ValueProperty(TYPE, "SafExportPolicy");
    @Type(base=Integer.class)
    @XmlBinding(path="messaging-performance-preference")
    @Label(standard="messaging performance preference")
    @NumericRange(min="0", max="100")
    @DefaultValue(text="25")
    @Documentation(content="Controls how long destinations are willing to wait to create full batches of available messages (if at all) for delivery to consumers. At the minimum value, batching is disabled; at the default value, less-than-full batches will not wait and are delivered immediately with currently available messages; setting higher than the default value controls the maximum wait time for additional messages before less-than-full batches are delivered to consumers.")
    public static final ValueProperty PROP_MESSAGING_PERFORMANCE_PREFERENCE = new ValueProperty(TYPE, "MessagingPerformancePreference");
    @Type(base=HandlingPolicy.class)
    @XmlBinding(path="unit-of-work-handling-policy")
    @Label(standard="unit-of-work (UOW) message handling policy")
    @DefaultValue(text="PassThrough")
    @Documentation(content="Specifies whether or not the Unit of Work (UOW) feature is enabled for this destination. A UOW is a set of messages that are processed as a single unit.[ul][li]Pass-Through: By default, this destination does not treat messages as part of a UOW.[/li][li]Single Message Delivery: This value should only be selected if UOW consumers are receiving messages on this destination. When selected, UOW messages are formed into a list and are consumed as an ObjectMessage containing the list.[/li][/ul]")
    public static final ValueProperty PROP_UNIT_OF_WORK_HANDLING_POLICY = new ValueProperty(TYPE, "UnitOfWorkHandlingPolicy");
    @NamedValues(arbitraryValueLabel="expiration time for incomplete UOW messages (msecs)", defaultArbitraryValue="60000", namedValues={@NamedValues.NamedValue(value="-1", label="UOW messages never expire")})
    @Type(base=Integer.class)
    @XmlBinding(path="incomplete-work-expiration-time")
    @Label(standard="expiration time for incomplete unit-of-work (UOW) messages")
    @NumericRange(min="-1")
    @DefaultValue(text="-1")
    @Documentation(content="Specifies the maximum length of time, in milliseconds, before undelivered messages in an incomplete UOW are expired. Such messages will then follow the expiration policy defined for undeliverable messages.")
    public static final ValueProperty PROP_INCOMPLETE_WORK_EXPIRATION_TIME = new ValueProperty(TYPE, "IncompleteWorkExpirationTime");
    @Type(base=Long.class)
    @XmlBinding(path="thresholds/bytes-high")
    @Label(standard="maximum bytes")
    @DefaultValue(text="max-long")
    @NumericRange(min="0")
    @Validation(rule="${ ThresholdBytesLow <= ThresholdBytesHigh }", message="Must be greater than or equal to minimum bytes.")
    @Fact(statement="Must be greater than or equal to minimum bytes.")
    @Documentation(content="The upper threshold (total number of bytes in this destination) that triggers logging or flow control events. The value of java.lang.Long.MAX_VALUE disables logging and flow control events for the destination.")
    public static final ValueProperty PROP_THRESHOLD_BYTES_HIGH = new ValueProperty(TYPE, "ThresholdBytesHigh");
    @Type(base=Long.class)
    @XmlBinding(path="thresholds/bytes-low")
    @Label(standard="minimum bytes")
    @DefaultValue(text="max-long")
    @NumericRange(min="0")
    @Validation(rule="${ ThresholdBytesLow <= ThresholdBytesHigh }", message="Must be less than or equal to maximum bytes.")
    @Fact(statement="Must be less than or equal to maximum bytes.")
    @Documentation(content="The lower threshold (total number of bytes in this destination) that triggers logging or flow control events. The value of java.lang.Long.MAX_VALUE disables logging and flow control events for the destination.")
    public static final ValueProperty PROP_THRESHOLD_BYTES_LOW = new ValueProperty(TYPE, "ThresholdBytesLow");
    @Type(base=Long.class)
    @XmlBinding(path="thresholds/messages-high")
    @Label(standard="maximum messages")
    @DefaultValue(text="max-long")
    @NumericRange(min="0")
    @Validation(rule="${ ThresholdMessagesLow <= ThresholdMessagesHigh }", message="Must be greater than or equal to minimum messages.")
    @Fact(statement="Must be greater than or equal to minimum messages.")
    @Documentation(content="The upper threshold (total number of messages in this destination) that triggers logging or flow control events. The value of java.lang.Long.MAX_VALUE disables logging and flow control events for the destination.")
    public static final ValueProperty PROP_THRESHOLD_MESSAGES_HIGH = new ValueProperty(TYPE, "ThresholdMessagesHigh");
    @Type(base=Long.class)
    @XmlBinding(path="thresholds/messages-low")
    @Label(standard="minimum messages")
    @DefaultValue(text="max-long")
    @NumericRange(min="0")
    @Validation(rule="${ ThresholdMessagesLow <= ThresholdMessagesHigh }", message="Must be less than or equal to maximum messages.")
    @Fact(statement="Must be less than or equal to maximum messages.")
    @Documentation(content="The lower threshold (total number of messages in this destination) that triggers logging or flow control events. The value of java.lang.Long.MAX_VALUE disables logging and flow control events for the destination.")
    public static final ValueProperty PROP_THRESHOLD_MESSAGES_LOW = new ValueProperty(TYPE, "ThresholdMessagesLow");

    public ElementList<IDestinationKeyReference> getDestinationKeys();

    public Value<AttachSenderCredentialsPolicy> getAttachSenderCredentialsPolicy();

    public void setAttachSenderCredentialsPolicy(String var1);

    public void setAttachSenderCredentialsPolicy(AttachSenderCredentialsPolicy var1);

    public Value<Boolean> getProductionPausedAtStartup();

    public void setProductionPausedAtStartup(String var1);

    public void setProductionPausedAtStartup(Boolean var1);

    public Value<Boolean> getInsertionPausedAtStartup();

    public void setInsertionPausedAtStartup(String var1);

    public void setInsertionPausedAtStartup(Boolean var1);

    public Value<Boolean> getConsumptionPausedAtStartup();

    public void setConsumptionPausedAtStartup(String var1);

    public void setConsumptionPausedAtStartup(Boolean var1);

    public Value<Integer> getMaximumMessageSize();

    public void setMaximumMessageSize(String var1);

    public void setMaximumMessageSize(Integer var1);

    public Value<String> getQuota();

    public void setQuota(String var1);

    public Value<Boolean> getDefaultUnitOfOrder();

    public void setDefaultUnitOfOrder(String var1);

    public void setDefaultUnitOfOrder(Boolean var1);

    public Value<SafExportPolicy> getSafExportPolicy();

    public void setSafExportPolicy(String var1);

    public void setSafExportPolicy(SafExportPolicy var1);

    public Value<Integer> getMessagingPerformancePreference();

    public void setMessagingPerformancePreference(String var1);

    public void setMessagingPerformancePreference(Integer var1);

    public Value<HandlingPolicy> getUnitOfWorkHandlingPolicy();

    public void setUnitOfWorkHandlingPolicy(String var1);

    public void setUnitOfWorkHandlingPolicy(HandlingPolicy var1);

    public Value<Integer> getIncompleteWorkExpirationTime();

    public void setIncompleteWorkExpirationTime(String var1);

    public void setIncompleteWorkExpirationTime(Integer var1);

    public Value<Long> getThresholdBytesHigh();

    public void setThresholdBytesHigh(String var1);

    public void setThresholdBytesHigh(Long var1);

    public Value<Long> getThresholdBytesLow();

    public void setThresholdBytesLow(String var1);

    public void setThresholdBytesLow(Long var1);

    public Value<Long> getThresholdMessagesHigh();

    public void setThresholdMessagesHigh(String var1);

    public void setThresholdMessagesHigh(Long var1);

    public Value<Long> getThresholdMessagesLow();

    public void setThresholdMessagesLow(String var1);

    public void setThresholdMessagesLow(Long var1);
}

