/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.ExpirationPolicy;
import oracle.eclipse.tools.weblogic.descriptors.jms.IMessageLoggingFormatPart;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.DestinationValuesProvider;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.DestinationValuesValidator;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.ExpirationLoggingPolicyBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NoDuplicates;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlListBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IDeliveryFailureParamsBase
extends Element {
    public static final ElementType TYPE = new ElementType(IDeliveryFailureParamsBase.class);
    @XmlBinding(path="delivery-failure-params/error-destination")
    @Label(standard="error destination")
    @Services(value={@Service(impl=DestinationValuesProvider.class), @Service(impl=DestinationValuesValidator.class)})
    @Documentation(content="The name of the target error destination for messages that have expired or reached their redelivery limit. If no error destination is configured, then such messages are simply dropped. If a message has reached its redelivery limit, or a message has expired and the Expiration Policy is set to Redirect, then the message is moved to the specified error destination.")
    public static final ValueProperty PROP_ERROR_DESTINATION = new ValueProperty(TYPE, "ErrorDestination");
    @NamedValues(arbitraryValueLabel="redelivery limit", defaultArbitraryValue="10", namedValues={@NamedValues.NamedValue(value="-1", label="destination will not override message producer")})
    @Type(base=Integer.class)
    @XmlBinding(path="delivery-failure-params/redelivery-limit")
    @Label(standard="number of redelivery tries")
    @NumericRange(min="-1")
    @Documentation(content="The number of redelivery tries a message can have before it is moved to the error destination. This setting overrides any redelivery limit set by the message sender. If the redelivery limit is configured, but no error destination is configured, then persistent and nonpersistent messages are simply dropped (deleted) when they reach their redelivery limit.")
    public static final ValueProperty PROP_REDELIVERY_LIMIT = new ValueProperty(TYPE, "RedeliveryLimit");
    @Type(base=ExpirationPolicy.class)
    @XmlBinding(path="delivery-failure-params/expiration-policy")
    @Label(standard="expiration policy")
    @Documentation(content="The message Expiration Policy to use when an expired message is encountered on a destination. [ul][li]Discard: Removes expired messages from the messaging system. The removal is not logged and the message is not redirected to another location.[/li][li]Log: Removes expired messages from the system and writes an entry to the server log file indicating that the messages have been removed from the system. The actual information that is logged is defined by the Expiration Logging Policy.[/li][li]Redirect: Moves expired messages from their current location to the error destination defined for the destination.[/li][/ul]")
    public static final ValueProperty PROP_EXPIRATION_POLICY = new ValueProperty(TYPE, "ExpirationPolicy");
    @Label(standard="expiration logging policy")
    @Type(base=IMessageLoggingFormatPart.class)
    @CustomXmlListBinding(impl=ExpirationLoggingPolicyBinding.class)
    @Enablement(expr="${ ExpirationPolicy == 'Log' }")
    @NoDuplicates
    @Documentation(content="The policy that defines what information about the message is logged when the Expiration Policy is set to Log.")
    public static final ListProperty PROP_EXPIRATION_LOGGING_POLICY = new ListProperty(TYPE, "ExpirationLoggingPolicy");

    public Value<String> getErrorDestination();

    public void setErrorDestination(String var1);

    public Value<Integer> getRedeliveryLimit();

    public void setRedeliveryLimit(String var1);

    public void setRedeliveryLimit(Integer var1);

    public Value<ExpirationPolicy> getExpirationPolicy();

    public void setExpirationPolicy(String var1);

    public void setExpirationPolicy(ExpirationPolicy var1);

    public ElementList<IMessageLoggingFormatPart> getExpirationLoggingPolicy();
}

