/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.DefaultDeliveryMode;
import oracle.eclipse.tools.weblogic.descriptors.jms.DefaultUnitOfOrder;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.DefaultUnitOfOrderBinding;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.UserGeneratedUOONameBinding;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.UserGeneratedUOOValidator;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IDefaultDeliveryParams
extends Element {
    public static final ElementType TYPE = new ElementType(IDefaultDeliveryParams.class);
    @Type(base=DefaultDeliveryMode.class)
    @XmlBinding(path="default-delivery-params/default-delivery-mode")
    @Label(standard="default delivery mode")
    @DefaultValue(text="Persistent")
    @Documentation(content="The default delivery mode used for messages when a delivery mode is not explicitly defined.")
    public static final ValueProperty PROP_DEFAULT_DELIVERY_MODE = new ValueProperty(TYPE, "DefaultDeliveryMode");
    @XmlBinding(path="default-delivery-params/default-time-to-deliver")
    @Label(standard="default time to deliver (msecs)")
    @DefaultValue(text="0")
    @Documentation(content="The delay time, in milliseconds, between when a message is produced and when it is made visible on its destination.")
    public static final ValueProperty PROP_DEFAULT_TIME_TO_DELIVER = new ValueProperty(TYPE, "DefaultTimeToDeliver");
    @Type(base=Long.class)
    @NamedValues(arbitraryValueLabel="default time to live (msecs)", defaultArbitraryValue="60000", namedValues={@NamedValues.NamedValue(value="0", label="messages never expire")})
    @XmlBinding(path="default-delivery-params/default-time-to-live")
    @Label(standard="default time to live")
    @NumericRange(min="0")
    @DefaultValue(text="0")
    @Documentation(content="The maximum length of time, in milliseconds, that a message will exist. This value is used for messages when a priority is not explicitly defined. A value of 0 indicates that the message has an infinite amount time to live.")
    public static final ValueProperty PROP_DEFAULT_TIME_TO_LIVE = new ValueProperty(TYPE, "DefaultTimeToLive");
    @Type(base=Integer.class)
    @XmlBinding(path="default-delivery-params/default-priority")
    @Label(standard="default priority")
    @NumericRange(min="0", max="9")
    @DefaultValue(text="4")
    @Documentation(content="The default priority used for messages when a priority is not explicitly defined.")
    public static final ValueProperty PROP_DEFAULT_PRIORITY = new ValueProperty(TYPE, "DefaultPriority");
    @Type(base=Long.class)
    @XmlBinding(path="default-delivery-params/default-redelivery-delay")
    @Label(standard="default redelivery delay (msecs)")
    @NumericRange(min="0")
    @DefaultValue(text="0")
    @Documentation(content="The delay time, in milliseconds, before rolled back or recovered messages are redelivered.")
    public static final ValueProperty PROP_DEFAULT_REDELIVERY_DELAY = new ValueProperty(TYPE, "DefaultRedeliveryDelay");
    @Type(base=Long.class)
    @NamedValues(arbitraryValueLabel="send timeout (msecs)", defaultArbitraryValue="10", namedValues={@NamedValues.NamedValue(value="0", label="sender does not want to wait for space")})
    @XmlBinding(path="default-delivery-params/send-timeout")
    @Label(standard="send timeout")
    @NumericRange(min="0")
    @DefaultValue(text="10")
    @Documentation(content="The maximum length of time, in milliseconds, that a sender will wait when there is not enough available space (no quota) on a destination to accommodate the message being sent.")
    public static final ValueProperty PROP_SEND_TIMEOUT = new ValueProperty(TYPE, "SendTimeout");
    @Type(base=Integer.class)
    @XmlBinding(path="default-delivery-params/default-compression-threshold")
    @Label(standard="default compression threshold (bytes)")
    @NumericRange(min="0")
    @DefaultValue(text="max-int")
    @Documentation(content="The number of bytes for the serialized message body so any message that exceeds this limit will trigger message compression when the message is sent or received by the JMS message producer or consumer.")
    public static final ValueProperty PROP_DEFAULT_COMPRESSION_THRESHOLD = new ValueProperty(TYPE, "DefaultCompressionThreshold");
    @Type(base=DefaultUnitOfOrder.class)
    @CustomXmlValueBinding(impl=DefaultUnitOfOrderBinding.class)
    @Label(standard="default unit-of-order for producer")
    @DefaultValue(text="None")
    @Documentation(content="The default Unit of Order name for producers that connect using this connection factory. A Unit of Order allows for messages to be processed in a certain order, even among multiple recipients.[ul][li]System-generated: Indicates that Oracle WebLogic Server will automatically generate a Unit of Order name.[/li][li]User-generated: Indicates that the Unit of Order name will come from the name specified name in the Unit of Order Name field.[/li][li]None:Indicates that no message ordering is enforced.[/li][/ul]")
    public static final ValueProperty PROP_DEFAULT_UNIT_OF_ORDER = new ValueProperty(TYPE, "DefaultUnitOfOrder");
    @CustomXmlValueBinding(impl=UserGeneratedUOONameBinding.class)
    @Label(standard="user generated unit-of-order name")
    @Service(impl=UserGeneratedUOOValidator.class)
    @Enablement(expr="${ DefaultUnitOfOrder == 'User-generated' }")
    @Required
    public static final ValueProperty PROP_USER_GENERATED_UOO_NAME = new ValueProperty(TYPE, "UserGeneratedUooName");

    public Value<DefaultDeliveryMode> getDefaultDeliveryMode();

    public void setDefaultDeliveryMode(String var1);

    public void setDefaultDeliveryMode(DefaultDeliveryMode var1);

    public Value<String> getDefaultTimeToDeliver();

    public void setDefaultTimeToDeliver(String var1);

    public Value<Long> getDefaultTimeToLive();

    public void setDefaultTimeToLive(String var1);

    public void setDefaultTimeToLive(Long var1);

    public Value<Integer> getDefaultPriority();

    public void setDefaultPriority(String var1);

    public void setDefaultPriority(Integer var1);

    public Value<Long> getDefaultRedeliveryDelay();

    public void setDefaultRedeliveryDelay(String var1);

    public void setDefaultRedeliveryDelay(Long var1);

    public Value<Long> getSendTimeout();

    public void setSendTimeout(String var1);

    public void setSendTimeout(Long var1);

    public Value<Integer> getDefaultCompressionThreshold();

    public void setDefaultCompressionThreshold(String var1);

    public void setDefaultCompressionThreshold(Integer var1);

    public Value<DefaultUnitOfOrder> getDefaultUnitOfOrder();

    public void setDefaultUnitOfOrder(String var1);

    public void setDefaultUnitOfOrder(DefaultUnitOfOrder var1);

    public Value<String> getUserGeneratedUooName();

    public void setUserGeneratedUooName(String var1);
}

