/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface ICommonDistributedQueue
extends Element {
    public static final ElementType TYPE = new ElementType(ICommonDistributedQueue.class);
    @Type(base=Integer.class)
    @NamedValues(arbitraryValueLabel="forward delay (secs)", defaultArbitraryValue="10", namedValues={@NamedValues.NamedValue(value="-1", label="no messages are forwarded")})
    @XmlBinding(path="forward-delay")
    @Label(standard="set the forward delay")
    @DefaultValue(text="-1")
    @Documentation(content="The number of seconds after which a distributed queue member with no consumers will wait before forwarding its messages to other distributed queue members that do have consumers.[pbr/]The default value of -1 disables this feature so that no messages are forwarded to other distributed queue members.")
    public static final ValueProperty PROP_FORWARD_DELAY = new ValueProperty(TYPE, "ForwardDelay");
    @Type(base=Boolean.class)
    @XmlBinding(path="reset-delivery-count-on-forward")
    @Label(standard="reset delivery count on forward")
    @DefaultValue(text="true")
    @Since(value="10.0")
    @Enablement(expr="${ ForwardDelay != -1 }")
    @Documentation(content="Determines whether or not the delivery count is reset during message forwarding between distributed queue members.")
    public static final ValueProperty PROP_RESET_DELIVERY_COUNT_ON_FORWARD = new ValueProperty(TYPE, "ResetDeliveryCountOnForward");

    public Value<Integer> getForwardDelay();

    public void setForwardDelay(String var1);

    public void setForwardDelay(Integer var1);

    public Value<Boolean> getResetDeliveryCountOnForward();

    public void setResetDeliveryCountOnForward(String var1);

    public void setResetDeliveryCountOnForward(Boolean var1);
}

