/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.LoadBalancingPolicy;
import oracle.eclipse.tools.weblogic.descriptors.jms.UnitOfOrderRouting;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface ICommonDistributedDestination
extends Element {
    public static final ElementType TYPE = new ElementType(ICommonDistributedDestination.class);
    @Type(base=LoadBalancingPolicy.class)
    @XmlBinding(path="load-balancing-policy")
    @Label(standard="load balancing policy")
    @DefaultValue(text="Round-Robin")
    @Documentation(content="Determines the load balancing policy for producers sending messages to a distributed destination in order to balance the message load across the members of the distributed set.[ul][li]Round-Robin: The system maintains an ordering of physical topic members within the set by distributing the messaging load across the topic members one at a time in the order that they are defined in the configuration file. Each Oracle WebLogic Server maintains an identical ordering, but may be at a different point within the ordering. If weights are assigned to any of the topic members in the set, then those members appear multiple times in the ordering.[/li][li]Random: The weight assigned to the topic members is used to compute a weighted distribution for the members of the set. The messaging load is distributed across the topic members by pseudo-randomly accessing the distribution. In the short run, the load will not be directly proportional to the weight. In the long run, the distribution will approach the limit of the distribution. A pure random distribution can be achieved by setting all the weights to the same value, which is typically set to 1.[/li][/ul]")
    public static final ValueProperty PROP_LOAD_BALANCING_POLICY = new ValueProperty(TYPE, "LoadBalancingPolicy");
    @Type(base=UnitOfOrderRouting.class)
    @XmlBinding(path="unit-of-order-routing")
    @Label(standard="unit-of-order routing")
    @DefaultValue(text="Hash")
    @Documentation(content="A particular Unit of Order must always first route to the same member. Choose a routing algorithm:[ul][li]Hash: Producers will compute the Distributed Destination Member from the hash code of the Unit of Order.  This is a good option if the number of members is static.  Do not choose this option if you plan to configure new members or remove members while messages are still in the system (otherwise the same UOO may route to two different members, and ordering will not be preserved).[/li][li]PathService: The Path Service will determine the Distributed Destination Member. Requires configuring of a path service in the cluster.  Consult the WebLogic JMS Programmers Guide for guidance.[/li][/ul]")
    public static final ValueProperty PROP_UNIT_OF_ORDER_ROUTING = new ValueProperty(TYPE, "UnitOfOrderRouting");

    public Value<LoadBalancingPolicy> getLoadBalancingPolicy();

    public void setLoadBalancingPolicy(String var1);

    public void setLoadBalancingPolicy(LoadBalancingPolicy var1);

    public Value<UnitOfOrderRouting> getUnitOfOrderRouting();

    public void setUnitOfOrderRouting(String var1);

    public void setUnitOfOrderRouting(UnitOfOrderRouting var1);
}

