/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc.internal;

import java.util.Set;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJdbcConfig;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.DataSourceType;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcDriverParameters;
import oracle.eclipse.tools.weblogic.jdbc.IJDBCDbInfoFactory;
import oracle.eclipse.tools.weblogic.jdbc.IJDBCDriverInfo;
import oracle.eclipse.tools.weblogic.jdbc.JDBCInfoFactoryUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Version;

public class UnknownDBPropertyHelper {
    public static boolean isUnknownPropertyRequired(IWebLogicJdbcConfig jdbcConfig, String propName) {
        IJdbcDriverParameters driverParam = jdbcConfig.getDriverParameters();
        String dbType = (String)driverParam.getDatabaseType().content();
        String dbDriver = (String)driverParam.getDatabaseDriver().content();
        IProject project = (IProject)driverParam.adapt(IProject.class);
        IWebLogicJdbcConfig model = (IWebLogicJdbcConfig)driverParam.nearest(IWebLogicJdbcConfig.class);
        IJDBCDbInfoFactory dbInfoFactory = JDBCInfoFactoryUtil.findJDBCDbInfoFactory(project, (Version)model.getServerVersion().content());
        DataSourceType dataSourceType = (DataSourceType)((Object)jdbcConfig.getDataSourceType().content());
        if (dbInfoFactory != null) {
            IJDBCDriverInfo driverInfo = null;
            if (dataSourceType.equals((Object)DataSourceType.GridLinkDataSource)) {
                boolean isXa = dbDriver != null && dbDriver.equals("Oracle's XA Driver");
                driverInfo = dbInfoFactory.getGridLinkDriverInfo(isXa);
            } else if (dbType != null && dbDriver != null) {
                driverInfo = dbInfoFactory.getDriverInfo(dbType, dbDriver);
            }
            if (driverInfo != null) {
                Set attrSet = driverInfo.getUnknownRequiredAttributes();
                for (String attrName : attrSet) {
                    if (!attrName.equals(propName)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

