/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc.internal;

import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcDriverParameters;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcHostPort;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyBinding;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.ValuePropertyBinding;
import org.eclipse.sapphire.modeling.DelimitedListBindingImpl;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlDelimitedListBindingImpl;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlPath;

public class HostPortsBinding
extends XmlDelimitedListBindingImpl {
    public HostPortsBinding() {
        super(new XmlPath("%hostports", (XmlNamespaceResolver)new StandardXmlNamespaceResolver(IJdbcDriverParameters.TYPE)));
    }

    protected char getDelimiter() {
        return ';';
    }

    protected DelimitedListBindingImpl.ListEntryResource createListEntryResource() {
        return new DelimitedListBindingImpl.ListEntryResource((DelimitedListBindingImpl)this){

            protected PropertyBinding createBinding(Property property) {
                PropertyDef p = property.definition();
                if (p == IJdbcHostPort.PROP_HOST_NAME) {
                    return new ValuePropertyBinding(){

                        public String read() {
                            return this.readHost();
                        }

                        public void write(String value) {
                            this.writeHostPort(value, this.readPort());
                        }
                    };
                }
                if (p == IJdbcHostPort.PROP_PORT) {
                    return new ValuePropertyBinding(){

                        public String read() {
                            return this.readPort();
                        }

                        public void write(String value) {
                            this.writeHostPort(this.readHost(), value);
                        }
                    };
                }
                throw new IllegalArgumentException();
            }

            private String readHost() {
                String text = this.getValue();
                if (text == null || text.length() == 0) {
                    return null;
                }
                int separator = text.indexOf(58);
                if (separator != -1) {
                    return text.substring(0, separator);
                }
                return text;
            }

            private String readPort() {
                String text = this.getValue();
                if (text == null || text.length() == 0) {
                    return null;
                }
                int separator = text.indexOf(58);
                if (separator != -1 && separator + 1 < text.length()) {
                    return text.substring(separator + 1);
                }
                return null;
            }

            private void writeHostPort(String host, String port) {
                StringBuilder buf = new StringBuilder();
                if (host != null) {
                    buf.append(host);
                }
                if (port != null) {
                    buf.append(':');
                    buf.append(port);
                }
                this.setValue(buf.toString());
            }
        };
    }
}

