/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.DbDriverRecord;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class DbDriversDatabase {
    private static boolean initialized = false;
    private static Map<String, List<DbDriverRecord>> dbMap = new HashMap<String, List<DbDriverRecord>>();

    public static SortedSet<String> getAllDbTypes() {
        DbDriversDatabase.initialize();
        TreeSet<String> result = new TreeSet<String>();
        Iterator<String> dbIt = dbMap.keySet().iterator();
        while (dbIt.hasNext()) {
            result.add(dbIt.next());
        }
        return result;
    }

    public static SortedSet<String> getDbDrivers(String dbType) {
        DbDriversDatabase.initialize();
        TreeSet<String> result = new TreeSet<String>();
        List<DbDriverRecord> records = dbMap.get(dbType);
        if (records != null) {
            for (DbDriverRecord record : records) {
                result.add(record.getDbDriver());
            }
        }
        return result;
    }

    public static DbDriverRecord getDbDriverRecord(String dbType, String dbDriver) {
        DbDriverRecord record = null;
        List<DbDriverRecord> records = dbMap.get(dbType);
        if (records != null) {
            for (DbDriverRecord driverRec : records) {
                if (!driverRec.getDbType().equalsIgnoreCase(dbType) || !driverRec.getDbDriver().equalsIgnoreCase(dbDriver)) continue;
                record = driverRec;
                break;
            }
        }
        return record;
    }

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        URL dbDriverDatabaseUrl = FileLocator.find((Bundle)WlsCorePlugin.getPluginBundle(), (IPath)new Path("resources/jdbc/dbdrivers.txt"), null);
        try {
            InputStream in = dbDriverDatabaseUrl.openStream();
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                String line = r.readLine();
                while (line != null) {
                    String[] segments = line.split("\\|\\|");
                    if (segments.length == 5 || segments.length == 6) {
                        String dbName = segments[0];
                        String driver = segments[1];
                        String driverType = segments[2];
                        boolean isXaDriver = driverType.equals("xa");
                        String url = segments[3];
                        String dbClass = segments[4];
                        String properties = null;
                        if (segments.length == 6) {
                            properties = segments[5];
                        }
                        DbDriverRecord record = new DbDriverRecord(dbName, driver, isXaDriver, url, dbClass, properties);
                        List<DbDriverRecord> list = dbMap.get(dbName);
                        if (list == null) {
                            list = new ArrayList<DbDriverRecord>();
                            list.add(record);
                            dbMap.put(dbName, list);
                        } else {
                            list.add(record);
                        }
                    }
                    line = r.readLine();
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            WlsCorePlugin.logException(e);
        }
        initialized = true;
    }
}

