/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc.internal;

import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJdbcConfig;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.DataSourceType;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.DriverType;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcDriverParameters;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.DriverURLHelper;
import oracle.eclipse.tools.weblogic.jdbc.IJDBCDbInfoFactory;
import oracle.eclipse.tools.weblogic.jdbc.IJDBCDriverInfo;
import oracle.eclipse.tools.weblogic.jdbc.JDBCInfoFactoryUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Version;

public class DbConfigListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        IProject project;
        IJDBCDbInfoFactory dbInfoFactory;
        IJdbcDriverParameters driverParam = (IJdbcDriverParameters)event.property().element().nearest(IJdbcDriverParameters.class);
        IWebLogicJdbcConfig jdbcConfig = (IWebLogicJdbcConfig)driverParam.nearest(IWebLogicJdbcConfig.class);
        boolean isGridLink = ((DataSourceType)((Object)jdbcConfig.getDataSourceType().content())).equals((Object)DataSourceType.GridLinkDataSource);
        boolean isXa = ((DriverType)((Object)jdbcConfig.getTransactionParameters().getDriverType().content())).equals((Object)DriverType.XaDriver);
        String dbType = (String)driverParam.getDatabaseType().content();
        String dbDriver = (String)driverParam.getDatabaseDriver().content();
        if ((isGridLink || dbType != null && dbDriver != null) && (dbInfoFactory = JDBCInfoFactoryUtil.findJDBCDbInfoFactory(project = (IProject)driverParam.adapt(IProject.class), (Version)jdbcConfig.getServerVersion().content())) != null) {
            IJDBCDriverInfo driverInfo = null;
            driverInfo = !isGridLink ? dbInfoFactory.getDriverInfo(dbType, dbDriver) : dbInfoFactory.getGridLinkDriverInfo(isXa);
            if (driverInfo != null) {
                String oldUrl = (String)driverParam.getUrl().content();
                String url = DriverURLHelper.computeURL(driverParam, driverInfo, isGridLink);
                if (url != null && oldUrl != null && !url.equals(oldUrl) || url != null && oldUrl == null || url == null && oldUrl != null) {
                    driverParam.setUrl(url);
                }
                if (url == null) {
                    DriverURLHelper.clearDriverProperties(driverParam);
                } else if (DriverURLHelper.driverPropertiesChanged(driverParam, driverInfo)) {
                    DriverURLHelper.updateDriverProperties(driverParam, driverInfo);
                }
            }
        }
    }
}

