/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc.internal;

import java.util.Set;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJdbcConfig;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.DataSourceType;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcDriverParameters;
import oracle.eclipse.tools.weblogic.jdbc.IJDBCDbInfoFactory;
import oracle.eclipse.tools.weblogic.jdbc.JDBCInfoFactoryUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.services.PossibleValuesService;

public class DatabaseDriverValuesProvider
extends PossibleValuesService {
    public static final String GRIDLINK_XA_DRIVER = "Oracle's XA Driver";
    public static final String GRIDLINK_NON_XA_DRIVER = "Oracle's Non XA Driver";

    protected void fillPossibleValues(Set<String> values) {
        IWebLogicJdbcConfig model = (IWebLogicJdbcConfig)this.context(IWebLogicJdbcConfig.class);
        IJdbcDriverParameters driverParam = (IJdbcDriverParameters)this.context(IJdbcDriverParameters.class);
        String dbName = (String)driverParam.getDatabaseType().content();
        IProject project = (IProject)((Element)this.context(Element.class)).adapt(IProject.class);
        IJDBCDbInfoFactory dbInfoFactory = JDBCInfoFactoryUtil.findJDBCDbInfoFactory(project, (Version)model.getServerVersion().content());
        if (dbInfoFactory != null) {
            String[] drivers;
            if (((DataSourceType)((Object)model.getDataSourceType().content())).equals((Object)DataSourceType.GridLinkDataSource)) {
                values.add(GRIDLINK_NON_XA_DRIVER);
                values.add(GRIDLINK_XA_DRIVER);
            } else if (((DataSourceType)((Object)model.getDataSourceType().content())).equals((Object)DataSourceType.GenericDataSource) && dbName != null && (drivers = dbInfoFactory.getDriverInfos(dbName)) != null) {
                String[] stringArray = drivers;
                int n = drivers.length;
                int n2 = 0;
                while (n2 < n) {
                    String driver = stringArray[n2];
                    values.add(driver);
                    ++n2;
                }
            }
        }
    }
}

