/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc.internal;

import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJdbcConfig;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.DataSourceType;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.DriverType;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcDriverParameters;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcOracleParameters;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcTransactionParameters;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.DriverURLHelper;
import oracle.eclipse.tools.weblogic.jdbc.IJDBCDbInfoFactory;
import oracle.eclipse.tools.weblogic.jdbc.IJDBCDriverInfo;
import oracle.eclipse.tools.weblogic.jdbc.JDBCInfoFactoryUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;

public class DatabaseDriverListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        IJDBCDriverInfo driverInfo;
        IJdbcDriverParameters driverParam = (IJdbcDriverParameters)event.property().element();
        String dbType = (String)driverParam.getDatabaseType().content();
        String dbDriver = (String)driverParam.getDatabaseDriver().content();
        IWebLogicJdbcConfig config = (IWebLogicJdbcConfig)driverParam.nearest(IWebLogicJdbcConfig.class);
        DataSourceType dataSourceType = (DataSourceType)((Object)config.getDataSourceType().content());
        IJdbcTransactionParameters transactionParam = config.getTransactionParameters();
        IProject project = (IProject)driverParam.adapt(IProject.class);
        IJDBCDbInfoFactory dbInfoFactory = JDBCInfoFactoryUtil.findJDBCDbInfoFactory(project, (Version)config.getServerVersion().content());
        if (dataSourceType.equals((Object)DataSourceType.GridLinkDataSource)) {
            IJDBCDriverInfo driverInfo2;
            boolean isXa;
            boolean bl = isXa = dbDriver != null && dbDriver.equals("Oracle's XA Driver");
            if (isXa) {
                transactionParam.setDriverType(DriverType.XaDriver);
            } else {
                transactionParam.setDriverType(DriverType.NonXaDriver);
            }
            if (dbInfoFactory != null && (driverInfo2 = dbInfoFactory.getGridLinkDriverInfo(isXa)) != null) {
                driverParam.setDriverClassName(driverInfo2.getDriverClassName());
            }
        } else if (dbType != null && dbDriver != null && dbInfoFactory != null && (driverInfo = dbInfoFactory.getDriverInfo(dbType, dbDriver)) != null) {
            IJdbcOracleParameters oracleParams;
            XmlElement oracleParamsEl;
            if (driverInfo.isXADriver()) {
                transactionParam.setDriverType(DriverType.XaDriver);
            } else {
                transactionParam.setDriverType(DriverType.NonXaDriver);
            }
            driverParam.setDriverClassName(driverInfo.getDriverClassName());
            if (driverInfo.getDbmsPortDefault() != null) {
                driverParam.setPort(driverInfo.getDbmsPortDefault());
            } else {
                driverParam.setPort("");
            }
            String oldUrl = (String)driverParam.getUrl().content();
            String url = DriverURLHelper.computeURL(driverParam, driverInfo, false);
            if (url != null && oldUrl != null && !url.equals(oldUrl) || url != null && oldUrl == null) {
                driverParam.setUrl(url);
            }
            if (url != null && DriverURLHelper.driverPropertiesChanged(driverParam, driverInfo)) {
                DriverURLHelper.updateDriverProperties(driverParam, driverInfo);
            }
            String dbVendor = driverInfo.getDbVendor();
            String driverVendor = driverInfo.getDriverVendor();
            if (!(dbVendor != null && dbVendor.equalsIgnoreCase("oracle") && driverVendor != null && driverVendor.equalsIgnoreCase("oracle") || (oracleParamsEl = ((XmlResource)(oracleParams = config.getOracleParameters()).adapt(XmlResource.class)).getXmlElement()) == null)) {
                oracleParamsEl.remove();
            }
        }
    }
}

