/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc;

import oracle.eclipse.tools.weblogic.descriptors.IDatabaseConnectionPoolXaProperties;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.DriverType;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.GlobalTransactionProtocol;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.GlobalTransactionProtocolBinding;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.JdbcDriverTypeBinding;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IJdbcTransactionParameters
extends IDatabaseConnectionPoolXaProperties {
    public static final ElementType TYPE = new ElementType(IJdbcTransactionParameters.class);
    @Type(base=DriverType.class)
    @Label(standard="JDBC driver type")
    @CustomXmlValueBinding(impl=JdbcDriverTypeBinding.class)
    @DefaultValue(text="NonXaDriver")
    public static final ValueProperty PROP_DRIVER_TYPE = new ValueProperty(TYPE, "DriverType");
    @Type(base=GlobalTransactionProtocol.class)
    @Label(standard="global transactions protocol")
    @DefaultValue(text="Disabled")
    @CustomXmlValueBinding(impl=GlobalTransactionProtocolBinding.class)
    public static final ValueProperty PROP_GLOBAL_TRANSACTION_PROTOCOL = new ValueProperty(TYPE, "GlobalTransactionProtocol");
    @Type(base=Boolean.class)
    @XmlBinding(path="jdbc-driver-params/use-xa-data-source-interface")
    @Label(standard="use XA datasource interface")
    @DefaultValue(text="true")
    @Documentation(content="Specifies that WebLogic Server should use the XA interface of the JDBC driver.[pbr/]If the JDBC driver class used to create database connections implements both XA and non-XA versions of a JDBC driver, you can set this attribute to indicate that WebLogic Server should treat the JDBC driver as an XA driver or as a non-XA driver.")
    public static final ValueProperty PROP_XA_DATA_SOURCE_INTERFACE_ENABLED = new ValueProperty(TYPE, "XaDataSourceInterfaceEnabled");
    @XmlBinding(path="jdbc-xa-params/keep-xa-conn-till-tx-complete")
    @DefaultValue(text="true")
    @Documentation(content="Enables WebLogic Server to associate the same XA database connection from the connection pool with a global transaction until the transaction completes.[pbr/]Only applies to connection pools that use an XA driver.")
    public static final ValueProperty PROP_KEEP_CONNECTION_UNTIL_COMPLETED_ENABLED = new ValueProperty(TYPE, IDatabaseConnectionPoolXaProperties.PROP_KEEP_CONNECTION_UNTIL_COMPLETED_ENABLED);
    @Type(base=Boolean.class)
    @XmlBinding(path="jdbc-data-source-params/keep-conn-after-local-tx")
    @Label(standard="keep connection after local transaction")
    @Documentation(content="Enables WebLogic Server to keep the physical database connection associated with the logical connection when committing a local transaction instead releasing it and getting another physical connection when needed.[pbr/]Setting this option to true may require additional connections to be configured on the database.[pbr/]Use this setting to work around specific problems with JDBC XA drivers.")
    public static final ValueProperty PROP_KEEP_CONNECTION_AFTER_LOCAL_TRANSACTION = new ValueProperty(TYPE, "KeepConnectionAfterLocalTransaction");
    @Type(base=Boolean.class)
    @XmlBinding(path="jdbc-data-source-params/keep-conn-after-global-tx")
    @Label(standard="keep connection after global transaction")
    @Since(value="10.3.6")
    @Documentation(content="Enables WebLogic Server to keep the physical database connection associated with the logical connection when committing a global transaction instead releasing it and getting another physical connection when needed.[pbr/]Setting this option to true may require additional connections to be configured on the database.")
    public static final ValueProperty PROP_KEEP_CONNECTION_AFTER_GLOBAL_TRANSACTION = new ValueProperty(TYPE, "KeepConnectionAfterGlobalTransaction");
    @XmlBinding(path="jdbc-xa-params/need-tx-ctx-on-close")
    @Documentation(content="Specifies whether the XA driver requires a distributed transaction context when closing various JDBC objects (result sets, statements, connections, and so forth). Only applies to connection pools that use an XA driver.[pbr/]When enabled, SQL exceptions that are thrown while closing the JDBC objects without a transaction context will be suppressed.")
    public static final ValueProperty PROP_TRANSACTION_CONTEXT_ON_CLOSE_NEEDED = new ValueProperty(TYPE, IDatabaseConnectionPoolXaProperties.PROP_TRANSACTION_CONTEXT_ON_CLOSE_NEEDED);
    @XmlBinding(path="jdbc-xa-params/xa-end-only-once")
    @Documentation(content="Specifies that XAResource.end() is called only once for each pending XAResource.start().[pbr/]This option prevents the XA driver from calling XAResource.end(TMSUSPEND) and XAResource.end(TMSUCCESS) successively. Only applies to data sources that use an XA driver.")
    public static final ValueProperty PROP_END_ONLY_ONCE_ENABLED = new ValueProperty(TYPE, IDatabaseConnectionPoolXaProperties.PROP_END_ONLY_ONCE_ENABLED);
    @XmlBinding(path="new-xa-conn-for-commit")
    public static final ValueProperty PROP_DEDICATED_CONNECTION_FOR_COMMIT_NEEDED = new ValueProperty(TYPE, IDatabaseConnectionPoolXaProperties.PROP_DEDICATED_CONNECTION_FOR_COMMIT_NEEDED);
    @XmlBinding(path="jdbc-xa-params/keep-logical-conn-open-on-release")
    @Documentation(content="Enables WebLogic Server to keep the logical JDBC connection open for a global transaction when the physical XA connection is returned to the connection pool.[pbr/]Select this option if the XA driver used to create database connections or the DBMS requires that a logical JDBC connection be kept open while transaction processing continues (although the physical XA connection can returned to the connection pool).")
    public static final ValueProperty PROP_KEEP_LOGICAL_CONNECTION_OPEN_ON_RELEASE_ENABLED = new ValueProperty(TYPE, IDatabaseConnectionPoolXaProperties.PROP_KEEP_LOGICAL_CONNECTION_OPEN_ON_RELEASE_ENABLED);
    @XmlBinding(path="jdbc-xa-params/resource-health-monitoring")
    @Label(standard="enable resource health monitoring")
    @DefaultValue(text="true")
    @Documentation(content="Enables JTA resource health monitoring for an XA data source. When enabled, if an XA resource fails to respond to an XA call within the period specified in MaxXACallMillis, WebLogic Server marks the data source as unhealthy and blocks any further calls to the resource.")
    public static final ValueProperty PROP_RESOURCE_HEALTH_MONITORING_ENABLED = new ValueProperty(TYPE, IDatabaseConnectionPoolXaProperties.PROP_RESOURCE_HEALTH_MONITORING_ENABLED);
    @XmlBinding(path="jdbc-xa-params/recover-only-once")
    @Documentation(content="Specifies that the transaction manager calls recover on the resource only once. Only applies to data sources that use an XA driver.")
    public static final ValueProperty PROP_RECOVER_ONLY_ONCE_ENABLED = new ValueProperty(TYPE, IDatabaseConnectionPoolXaProperties.PROP_RECOVER_ONLY_ONCE_ENABLED);
    @XmlBinding(path="jdbc-xa-params/xa-set-transaction-timeout")
    @Documentation(content="Enables WebLogic Server to set a transaction branch timeout based on the value for XaTransactionTimeout.[pbr/]When enabled, the WebLogic Server Transaction Manager calls XAResource.setTransactionTimeout() before calling XAResource.start, and passes either the XA Transaction Timeout value or the global transaction timeout.[pbr/]You may want to set a transaction branch timeout if you have long-running transactions that exceed the default timeout value on the XA resource.")
    public static final ValueProperty PROP_TRANSACTION_TIMEOUT_ENABLED = new ValueProperty(TYPE, IDatabaseConnectionPoolXaProperties.PROP_TRANSACTION_TIMEOUT_ENABLED);
    @NamedValues(arbitraryValueLabel="transaction timeout period (secs)", defaultArbitraryValue="10", namedValues={@NamedValues.NamedValue(value="0", label="use global WLS transaction timeout")})
    @Label(standard="XA transaction timeout period (secs)")
    @XmlBinding(path="jdbc-xa-params/xa-transaction-timeout")
    @Documentation(content="The number of seconds to set as the transaction branch timeout.[pbr/]If set, this value is passed as the transaction timeout value in the XAResource.setTransactionTimeout() call on the XA resource manager, typically the JDBC driver.[pbr/]When this value is set to 0, the WebLogic Server Transaction Manager passes the global WebLogic Server transaction timeout in seconds in the method.[pbr/]If set, this value should be greater than or equal to the global WebLogic Server transaction timeout.")
    public static final ValueProperty PROP_TRANSACTION_TIMEOUT = new ValueProperty(TYPE, IDatabaseConnectionPoolXaProperties.PROP_TRANSACTION_TIMEOUT);
    @XmlBinding(path="jdbc-xa-params/rollback-local-tx-upon-conn-close")
    @Deprecated
    @Documentation(content="Enables WebLogic Server to call rollback() on the connection before returning the connection to the connection pool.[pbr/]Enabling this attribute will have a performance impact as the rollback call requires communication with the database server.")
    public static final ValueProperty PROP_ROLLBACK_LOCAL_TX_UPON_CLOSE_ENABLED = new ValueProperty(TYPE, IDatabaseConnectionPoolXaProperties.PROP_ROLLBACK_LOCAL_TX_UPON_CLOSE_ENABLED);
    @NamedValues(arbitraryValueLabel="retry duration (secs)", defaultArbitraryValue="10", namedValues={@NamedValues.NamedValue(value="0", label="no retries")})
    @Type(base=Integer.class)
    @XmlBinding(path="jdbc-xa-params/xa-retry-duration-seconds")
    @Label(standard="XA retry duration (secs)")
    @DefaultValue(text="0")
    @NumericRange(min="0")
    @Documentation(content="Determines the duration in seconds for which the transaction manager will perform recover operations on the resource. A value of zero indicates that no retries will be performed.")
    public static final ValueProperty PROP_RETRY_DURATION = new ValueProperty(TYPE, "RetryDuration");
    @Type(base=Integer.class)
    @XmlBinding(path="jdbc-xa-params/xa-retry-interval-seconds")
    @Label(standard="XA retry interval (secs)")
    @DefaultValue(text="60")
    @NumericRange(min="0")
    @Documentation(content="The number of seconds between XA retry operations if XARetryDurationSeconds is set to a positive value.")
    public static final ValueProperty PROP_RETRY_INTERVAL = new ValueProperty(TYPE, "RetryInterval");
    @XmlBinding(path="jdbc-connection-pool-params/jdbc-xa-debug-level")
    @Label(standard="XA debug level")
    @NumericRange(min="0", max="100")
    @Documentation(content="Specifies level of JDBC debugging for XA drivers.")
    public static final ValueProperty PROP_DEBUG_LEVEL = new ValueProperty(TYPE, IDatabaseConnectionPoolXaProperties.PROP_DEBUG_LEVEL);

    public Value<DriverType> getDriverType();

    public void setDriverType(String var1);

    public void setDriverType(DriverType var1);

    public Value<GlobalTransactionProtocol> getGlobalTransactionProtocol();

    public void setGlobalTransactionProtocol(String var1);

    public void setGlobalTransactionProtocol(GlobalTransactionProtocol var1);

    public Value<Boolean> isXaDataSourceInterfaceEnabled();

    public void setXaDataSourceInterfaceEnabled(String var1);

    public void setXaDataSourceInterfaceEnabled(Boolean var1);

    public Value<Boolean> isKeepConnectionAfterLocalTransaction();

    public void setKeepConnectionAfterLocalTransaction(String var1);

    public void setKeepConnectionAfterLocalTransaction(Boolean var1);

    public Value<Boolean> isKeepConnectionAfterGlobalTransaction();

    public void setKeepConnectionAfterGlobalTransaction(String var1);

    public void setKeepConnectionAfterGlobalTransaction(Boolean var1);

    public Value<Integer> getRetryDuration();

    public void setRetryDuration(Integer var1);

    public void setRetryDuration(String var1);

    public Value<Integer> getRetryInterval();

    public void setRetryInterval(Integer var1);

    public void setRetryInterval(String var1);
}

