/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc;

import oracle.eclipse.tools.weblogic.descriptors.DatabasePreparedStatementCacheType;
import oracle.eclipse.tools.weblogic.descriptors.IDatabaseConnectionPoolSizeProperties;
import oracle.eclipse.tools.weblogic.descriptors.IDatabaseConnectionTestingProperties;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.ConnectionPoolCapacityValidator;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IJdbcConnectionPoolParameters
extends IDatabaseConnectionPoolSizeProperties,
IDatabaseConnectionTestingProperties {
    public static final ElementType TYPE = new ElementType(IJdbcConnectionPoolParameters.class);
    @Service(impl=ConnectionPoolCapacityValidator.class)
    @Documentation(content="The number of physical connections to create when creating the connection pool.[pbr/]If unable to create this number of connections, creation of this connection pool will fail.")
    public static final ValueProperty PROP_INITIAL_CAPACITY = new ValueProperty(TYPE, IDatabaseConnectionPoolSizeProperties.PROP_INITIAL_CAPACITY);
    @Service(impl=ConnectionPoolCapacityValidator.class)
    @Documentation(content="The maximum number of physical connections that this connection pool can contain.")
    public static final ValueProperty PROP_MAXIMUM_CAPACITY = new ValueProperty(TYPE, IDatabaseConnectionPoolSizeProperties.PROP_MAXIMUM_CAPACITY);
    @Type(base=Integer.class)
    @XmlBinding(path="min-capacity")
    @Label(standard="minimum capacity")
    @NumericRange(min="0")
    @DefaultValue(text="1")
    @Since(value="10.3.6")
    @Service(impl=ConnectionPoolCapacityValidator.class)
    @Documentation(content="The minimum number of physical connections that this connection pool can contain after shrinking.")
    public static final ValueProperty PROP_MINIMUM_CAPACITY = new ValueProperty(TYPE, "MinimumCapacity");
    @Deprecated
    @Documentation(content="The number of connections created when new connections are added to the connection pool.[pbr/]When there are no more available physical connections to satisfy connection requests, WebLogic Server creates this number of additional physical connections and adds them to the connection pool.[pbr/]In WebLogic Server 10.3.1 and higher releases, the capacityIncrement is no longer configurable and is set to a value of 1.[pbr/]This attribute is deprecated.")
    public static final ValueProperty PROP_CAPACITY_INCREMENT = new ValueProperty(TYPE, IDatabaseConnectionPoolSizeProperties.PROP_CAPACITY_INCREMENT);
    @Type(base=Integer.class)
    @XmlBinding(path="shrink-frequency-seconds")
    @Label(standard="shrink frequency (secs)")
    @DefaultValue(text="900")
    @NumericRange(min="0")
    @Documentation(content="The number of seconds to wait before shrinking a connection pool that has incrementally increased to meet demand.[pbr/]When set to 0, shrinking is disabled.")
    public static final ValueProperty PROP_SHRINK_FREQUENCY = new ValueProperty(TYPE, "ShrinkFrequency");
    @Documentation(content="The maximum number of connection requests that can concurrently block threads while waiting to reserve a connection from the data soiurce's connection pool.")
    public static final ValueProperty PROP_MAXIMUM_WAITING_THREADS = new ValueProperty(TYPE, IDatabaseConnectionPoolSizeProperties.PROP_MAXIMUM_WAITING_THREADS);
    @Documentation(content="The number of seconds between attempts to establish connections to the database.[pbr/]If you do not set this value, data source creation fails if the database is unavailable. If set and if the database is unavailable when the data source is created, WebLogic Server will attempt to create connections in the pool again after the number of seconds you specify, and will continue to attempt to create the connections until it succeeds.[pbr/]When set to 0, connection retry is disabled.")
    public static final ValueProperty PROP_CREATION_RETRY_FREQUENCY = new ValueProperty(TYPE, IDatabaseConnectionTestingProperties.PROP_CREATION_RETRY_FREQUENCY);
    @Documentation(content="The number of seconds after which a call to reserve a connection from the connection pool will timeout.[pbr/]When set to 0, a call will never timeout.[pbr/]When set to -1, a call will timeout immediately.")
    public static final ValueProperty PROP_RESERVE_TIMEOUT = new ValueProperty(TYPE, IDatabaseConnectionTestingProperties.PROP_RESERVE_TIMEOUT);
    @Type(base=Boolean.class)
    @XmlBinding(path="test-connections-on-reserve")
    @Label(standard="test connections on reserve")
    @DefaultValue(text="false")
    @Documentation(content="Enables WebLogic Server to test a connection before giving it to a client. (Requires that you specify a Test Table Name.)[pbr/]The test adds a small delay in serving the client's request for a connection from the pool, but ensures that the client receives a viable connection.[pbr/]This test is required for connection pools used in a multi data source that use the failover algorithm.")
    public static final ValueProperty PROP_TEST_ON_RESERVE = new ValueProperty(TYPE, "TestOnReserve");
    @Type(base=Boolean.class)
    @XmlBinding(path="ignore-in-use-connections-enabled")
    @Label(standard="ignore in-use connections")
    @DefaultValue(text="true")
    @Documentation(content="Enables the data source to be shutdown even if connections obtained from the pool are still in use.")
    public static final ValueProperty PROP_IGNORE_IN_USE_CONNECTIONS_ENABLED = new ValueProperty(TYPE, "IgnoreInUseConnectionsEnabled");
    @Documentation(content="The number of inactive seconds on a reserved connection before WebLogic Server reclaims the connection and releases it back into the connection pool.[pbr/]You can use the Inactive Connection Timeout feature to reclaim leaked connections - connections that were not explicitly closed by the application. Note that this feature is not intended to be used in place of properly closing connections.[pbr/]When set to 0, the feature is disabled.")
    public static final ValueProperty PROP_INACTIVE_TIMEOUT = new ValueProperty(TYPE, IDatabaseConnectionTestingProperties.PROP_INACTIVE_TIMEOUT);
    @XmlBinding(path="test-table-name")
    @Label(standard="test table name")
    @Documentation(content="The name of the database table to use when testing physical database connections. This name is required when you specify a Test Frequency and enable Test Reserved Connections.[pbr/]The default SQL code used to test a connection is \"select count(*) from TestTableName\"[pbr/]Most database servers optimize this SQL to avoid a table scan, but it is still a good idea to set the Test Table Name to the name of a table that is known to have few rows, or even no rows.[pbr/]If the Test Table Name begins with \"SQL \", then the rest of the string following that leading token will be taken as a literal SQL statement that will be used to test connections instead of the standard query. For example: SQL BEGIN; Null; END;")
    public static final ValueProperty PROP_TABLE_NAME = new ValueProperty(TYPE, IDatabaseConnectionTestingProperties.PROP_TABLE_NAME);
    @Type(base=Integer.class)
    @XmlBinding(path="login-delay-seconds")
    @Label(standard="login delay (secs)")
    @DefaultValue(text="0")
    @NumericRange(min="0")
    @Documentation(content="The number of seconds to delay before creating each physical database connection. This delay supports database servers that cannot handle multiple connection requests in rapid succession.[pbr/]The delay takes place both during initial data source creation and during the lifetime of the data source whenever a physical database connection is created.")
    public static final ValueProperty PROP_LOGIN_DELAY = new ValueProperty(TYPE, "LoginDelay");
    @Documentation(content="SQL statement to execute that will initialize newly created physical database connections. Start the statement with SQL followed by a space.[pbr/]If the Init SQL value begins with \"SQL \", then the rest of the string following that leading token will be taken as a literal SQL statement that will be used to initialize database connections. If the Init SQL value does not begin with \"SQL \", the value will be treated as the name of a table and the following SQL statement will be used to initialize connections:[br/]\"select count(*) from InitSQL\"[pbr/]The table InitSQL must exist and be accessible to the database user for the connection. Most database servers optimize this SQL to avoid a table scan, but it is still a good idea to set InitSQL to the name of a table that is known to have few rows, or even no rows.")
    public static final ValueProperty PROP_INIT_SQL_STATEMENT = new ValueProperty(TYPE, IDatabaseConnectionTestingProperties.PROP_INIT_SQL_STATEMENT);
    @NamedValues(arbitraryValueLabel="statement cache size", defaultArbitraryValue="10", namedValues={@NamedValues.NamedValue(value="0", label="turn off statement caching")})
    @Type(base=Integer.class)
    @XmlBinding(path="statement-cache-size")
    @Label(standard="the number of prepared and callable statements stored in the cache")
    @DefaultValue(text="10")
    @NumericRange(min="0", max="1024")
    @Documentation(content="The number of prepared and callable statements stored in the cache. (This may increase server performance.)[pbr/]WebLogic Server can reuse statements in the cache without reloading the statements, which can increase server performance. Each connection in the connection pool has its own cache of statements.[pbr/]Setting the size of the statement cache to 0 turns off statement caching.")
    public static final ValueProperty PROP_STATEMENT_CACHE_SIZE = new ValueProperty(TYPE, "StatementCacheSize");
    @Type(base=DatabasePreparedStatementCacheType.class)
    @XmlBinding(path="statement-cache-type")
    @Label(standard="statement cache type")
    @DefaultValue(text="LRU")
    @Required
    @Documentation(content="The algorithm used for maintaining the prepared statements stored in the statement cache.[pbr/]Options are:[ul][li]LRU: when a new prepared or callable statement is used, the least recently used statement is replaced in the cache.[/li][li]FIXED: the first fixed number of prepared and callable statements are cached.[/li][/ul]")
    public static final ValueProperty PROP_STATEMENT_CACHE_TYPE = new ValueProperty(TYPE, "StatementCacheType");
    @Type(base=Boolean.class)
    @XmlBinding(path="remove-infected-connections")
    @Label(standard="remove infected connections")
    @Documentation(content="Specifies whether a connection will be removed from the connection pool after the application uses the underlying vendor connection object.[pbr/]If you disable removing infected connections, you must make sure that the database connection is suitable for reuse by other applications.[pbr/]When set to true (the default), the physical connection is not returned to the connection pool after the application closes the logical connection. Instead, the physical connection is closed and recreated.[pbr/]When set to false, when the application closes the logical connection, the physical connection is returned to the connection pool and can be reused by the application or by another application.")
    public static final ValueProperty PROP_REMOVE_INFECTED_CONNECTIONS_ENABLED = new ValueProperty(TYPE, "RemoveInfectedConnectionsEnabled");
    @Type(base=Integer.class)
    @XmlBinding(path="seconds-to-trust-an-idle-pool-connection")
    @Label(standard="seconds to trust an idle pool connection")
    @DefaultValue(text="10")
    @NumericRange(min="0")
    @Documentation(content="The number of seconds within a connection use that WebLogic Server trusts that the connection is still viable and will skip the connection test, either before delivering it to an application or during the periodic connection testing process.[pbr/]This option is an optimization that minimizes the performance impact of connection testing, especially during heavy traffic.")
    public static final ValueProperty PROP_SECONDS_TO_TRUST_IDLE_CONNECTION = new ValueProperty(TYPE, "SecondsToTrustIdleConnection");
    @NamedValues(arbitraryValueLabel="statement timeout (secs)", defaultArbitraryValue="10", namedValues={@NamedValues.NamedValue(value="-1", label="disables statement timeout"), @NamedValues.NamedValue(value="0", label="never time out")})
    @Type(base=Integer.class)
    @XmlBinding(path="statement-timeout")
    @Label(standard="The time (secs) after which a statement will time out")
    @DefaultValue(text="-1")
    @NumericRange(min="-1")
    @Documentation(content="The time after which a statement currently being executed will time out.[pbr/]StatementTimeout relies on underlying JDBC driver support. WebLogic Server passes the time specified to the JDBC driver using the java.sql.Statement.setQueryTimeout() method. If your JDBC driver does not support this method, it may throw an exception and the timeout value is ignored.[pbr/]A value of -1 disables this feature.[pbr/]A value of 0 means that statements will not time out.")
    public static final ValueProperty PROP_STATEMENT_TIME_OUT = new ValueProperty(TYPE, "StatementTimeOut");
    @Type(base=Integer.class)
    @XmlBinding(path="profile type")
    @DefaultValue(text="0")
    @NumericRange(min="0")
    public static final ValueProperty PROP_PROFILE_TYPE = new ValueProperty(TYPE, "ProfileType");
    @Type(base=Integer.class)
    @XmlBinding(path="jdbc-xa-debug-level")
    @Label(standard="XA debug level")
    @DefaultValue(text="10")
    public static final ValueProperty PROP_XA_DEBUG_LEVEL = new ValueProperty(TYPE, "XaDebugLevel");
    @Type(base=Boolean.class)
    @XmlBinding(path="credential-mapping-enabled")
    @Label(standard="set client ID on connection")
    public static final ValueProperty PROP_CREDENTIAL_MAPPING_ENABLED = new ValueProperty(TYPE, "CredentialMappingEnabled");
    @XmlBinding(path="driver-interceptor")
    @Label(standard="driver interceptor")
    public static final ValueProperty PROP_DRIVER_INTERCEPTOR = new ValueProperty(TYPE, "DriverInterceptor");
    @Type(base=Boolean.class)
    @XmlBinding(path="pinned-to-thread")
    @Label(standard="pinned to thread")
    @DefaultValue(text="false")
    @Documentation(content="PinnedToThread is an option that can improve performance by enabling execute threads to keep a pooled database connection even after the application closes the logical connection.[pbr/]When PinnedToThread is enabled, WebLogic Server pins a database connection from the connection pool to an execution thread the first time an application uses the thread to reserve a connection. When the application finishes using the connection and calls connection.close(), which otherwise returns the connection to the connection pool, WebLogic Server keeps the connection with the execute thread and does not return it to the connection pool. When an application subsequently requests a connection using the same execute thread, WebLogic Server provides the connection already reserved by the thread.[pbr/]With PinnedToThread, there is no locking contention on the connection pool that occurs when multiple threads attempt to reserve a connection at the same time and there is no contention for threads that attempt to reserve the same connection from a limited number of database connections.[pbr/]If an application concurrently reserves more than one connection from the connection pool using the same execute thread, WebLogic Server creates additional database connections and pins them to the thread, as well.")
    public static final ValueProperty PROP_PINNED_TO_THREAD = new ValueProperty(TYPE, "PinnedToThread");
    @Type(base=Boolean.class)
    @XmlBinding(path="identity-based-connection-pooling-enabled")
    @Label(standard="Enable Identity Based Connection Pooling")
    @DefaultValue(text="false")
    public static final ValueProperty PROP_IDENTITY_BASED_CONNECTION_POOLING = new ValueProperty(TYPE, "IdentityBasedConnectionPooling");
    @Type(base=Boolean.class)
    @XmlBinding(path="wrap-types")
    @Label(standard="wrap data types")
    @DefaultValue(text="true")
    @Documentation(content="By default, data type objects for Array, Blob, Clob, NClob, Ref, SQLXML, and Struct, plus ParameterMetaData and ResultSetMetaData objects are wrapped with a WebLogic wrapper. This allows for features like debugging and connection usage to be done by the server.[pbr/]The wrapping can be turned off by setting this value to false. This improves performance, in some cases significantly, and allows for the application to use the native driver objects directly.")
    public static final ValueProperty PROP_WRAP_DATA_TYPES = new ValueProperty(TYPE, "WrapDataTypes");
    @XmlBinding(path="fatal-error-codes")
    @Label(standard="fatal error codes")
    @Since(value="10.3.6")
    @Documentation(content="This value is used to configure error codes to be treated as fatal errors so that a connection is not put back in the pool. It is a comma separated list of error codes.[pbr/]The fatal-error-codes tag defines the fatal error codes that when specified as the exception code within a SQLException (retrieved by sqlException.getErrorCode()) indicates that a fatal error has occurred and the database is no longer reachable.")
    public static final ValueProperty PROP_FATAL_ERROR_CODES = new ValueProperty(TYPE, "FatalErrorCodes");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @XmlBinding(path="connection-labeling-callback")
    @Label(standard="connection labeling callback")
    @Since(value="10.3.6")
    @Documentation(content="The name of the connection labeling callback. This is automatically passed to registerConnectionLabelingCallback when the datasource is created.")
    public static final ValueProperty PROP_CONNECTION_LABELING_CALLBACK = new ValueProperty(TYPE, "ConnectionLabelingCallback");

    public Value<Integer> getMinimumCapacity();

    public void setMinimumCapacity(String var1);

    public void setMinimumCapacity(Integer var1);

    @Override
    public Value<Integer> getShrinkFrequency();

    @Override
    public void setShrinkFrequency(String var1);

    @Override
    public void setShrinkFrequency(Integer var1);

    public Value<Boolean> isTestOnReserve();

    public void setTestOnReserve(String var1);

    public void setTestOnReserve(Boolean var1);

    public Value<Boolean> isIgnoreInUseConnectionsEnabled();

    public void setIgnoreInUseConnectionsEnabled(String var1);

    public void setIgnoreInUseConnectionsEnabled(Boolean var1);

    public Value<Integer> getLoginDelay();

    public void setLoginDelay(String var1);

    public void setLoginDelay(Integer var1);

    public Value<Integer> getStatementCacheSize();

    public void setStatementCacheSize(String var1);

    public void setStatementCacheSize(Integer var1);

    public Value<DatabasePreparedStatementCacheType> getStatementCacheType();

    public void setStatementCacheType(String var1);

    public void setStatementCacheType(DatabasePreparedStatementCacheType var1);

    public Value<Boolean> isRemoveInfectedConnectionsEnabled();

    public void setRemoveInfectedConnectionsEnabled(String var1);

    public void setRemoveInfectedConnectionsEnabled(Boolean var1);

    public Value<Integer> getSecondsToTrustIdleConnection();

    public void setSecondsToTrustIdleConnection(String var1);

    public void setSecondsToTrustIdleConnection(Integer var1);

    public Value<Integer> getStatementTimeOut();

    public void setStatementTimeOut(String var1);

    public void setStatementTimeOut(Integer var1);

    public Value<Integer> getProfileType();

    public void setProfileType(String var1);

    public void setProfileType(Integer var1);

    public Value<Integer> getXaDebugLevel();

    public void setXaDebugLevel(String var1);

    public void setXaDebugLevel(Integer var1);

    public Value<Boolean> isCredentialMappingEnabled();

    public void setCredentialMappingEnabled(String var1);

    public void setCredentialMappingEnabled(Boolean var1);

    public Value<String> getDriverInterceptor();

    public void setDriverInterceptor(String var1);

    public Value<Boolean> isPinnedToThread();

    public void setPinnedToThread(String var1);

    public void setPinnedToThread(Boolean var1);

    public Value<Boolean> isIdentityBasedConnectionPooling();

    public void setIdentityBasedConnectionPooling(String var1);

    public void setIdentityBasedConnectionPooling(Boolean var1);

    public Value<Boolean> isWrapDataTypes();

    public void setWrapDataTypes(String var1);

    public void setWrapDataTypes(Boolean var1);

    public Value<String> getFatalErrorCodes();

    public void setFatalErrorCodes(String var1);

    public ReferenceValue<JavaTypeName, JavaType> getConnectionLabelingCallback();

    public void setConnectionLabelingCallback(String var1);

    public void setConnectionLabelingCallback(JavaTypeName var1);
}

