/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.internal;

import java.util.Set;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class WtpModuleUriValuesProvider
extends PossibleValuesService {
    private final Filter filter;

    public WtpModuleUriValuesProvider() {
        this(null);
    }

    protected WtpModuleUriValuesProvider(Filter filter) {
        this.filter = filter;
    }

    protected void fillPossibleValues(Set<String> values) {
        IModelProvider modelProvider;
        IProject project = (IProject)((Element)this.context(Element.class)).adapt(IProject.class);
        if (project != null && (modelProvider = ModelProviderManager.getModelProvider((IProject)project)) != null) {
            Object model = modelProvider.getModelObject();
            if (model instanceof Application) {
                Application app = (Application)model;
                for (Module module : app.getModules()) {
                    String uri;
                    if (this.filter == null || !this.filter.check(module) || (uri = module.getUri()) == null) continue;
                    values.add(uri);
                }
                IVirtualComponent earcomp = ComponentCore.createComponent((IProject)project);
                if (earcomp != null) {
                    IVirtualReference[] iVirtualReferenceArray = earcomp.getReferences();
                    int n = iVirtualReferenceArray.length;
                    int uri = 0;
                    while (uri < n) {
                        IVirtualReference ref = iVirtualReferenceArray[uri];
                        IVirtualComponent comp = ref.getReferencedComponent();
                        IProject pj = comp.getProject();
                        if (this.filter != null && this.filter.check(pj)) {
                            StringBuilder uri2 = new StringBuilder();
                            uri2.append(pj.getName());
                            int i = 0;
                            int n2 = uri2.length();
                            while (i < n2) {
                                char ch = uri2.charAt(i);
                                if (ch == ' ') {
                                    uri2.setCharAt(i, '_');
                                }
                                ++i;
                            }
                            if (WtpProjectUtil.isDynamicWebProject((IProject)pj)) {
                                uri2.append(".war");
                            } else {
                                uri2.append(".jar");
                            }
                            String uristr = uri2.toString();
                            if (!values.contains(uristr)) {
                                values.add(uristr);
                            }
                        }
                        ++uri;
                    }
                }
            } else if (model instanceof org.eclipse.jst.j2ee.application.Application) {
                org.eclipse.jst.j2ee.application.Application app = (org.eclipse.jst.j2ee.application.Application)model;
                for (org.eclipse.jst.j2ee.application.Module module : app.getModules()) {
                    String uri;
                    if (this.filter == null || !this.filter.check(module) || (uri = module.getUri()) == null) continue;
                    values.add(uri);
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }

    protected static abstract class Filter {
        protected Filter() {
        }

        public abstract boolean check(Module var1);

        public abstract boolean check(org.eclipse.jst.j2ee.application.Module var1);

        public abstract boolean check(IProject var1);
    }
}

