/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.weblogic.descriptors.ISecurityPermission;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;

public final class SecurityPermissionPropertiesBinding
extends XmlValueBindingImpl {
    private static final String PARSING_PATTERN_STR = "\\s*grant\\s*\\{\\s*permission\\s*([^ ]*)\\s*\"([^\"]*)\"\\s*,\\s*\"([^\"]*)\"\\s*\\}\\s*;\\s*";
    private static final Pattern PARSING_PATTERN = Pattern.compile("\\s*grant\\s*\\{\\s*permission\\s*([^ ]*)\\s*\"([^\"]*)\"\\s*,\\s*\"([^\"]*)\"\\s*\\}\\s*;\\s*");
    private static final XmlPath PATH_SECURITY_PERMISSION_SPEC = new XmlPath("security-permission-spec");

    public String read() {
        SecurityPermissionSpec spec = SecurityPermissionPropertiesBinding.getSecurityPermissionSpec((ISecurityPermission)this.property().element());
        PropertyDef property = this.property().definition();
        if (property == ISecurityPermission.PROP_CLASS_NAME) {
            return spec.getClassName();
        }
        if (property == ISecurityPermission.PROP_TARGET) {
            return spec.getTarget();
        }
        if (property == ISecurityPermission.PROP_ACTIONS) {
            return spec.getActions();
        }
        throw new IllegalArgumentException();
    }

    public void write(String value) {
        SecurityPermissionSpec spec = SecurityPermissionPropertiesBinding.getSecurityPermissionSpec((ISecurityPermission)this.property().element());
        PropertyDef property = this.property().definition();
        if (property == ISecurityPermission.PROP_CLASS_NAME) {
            spec.setClassName(value);
        } else if (property == ISecurityPermission.PROP_TARGET) {
            spec.setTarget(value);
        } else if (property == ISecurityPermission.PROP_ACTIONS) {
            spec.setActions(value);
        } else {
            throw new IllegalArgumentException();
        }
        SecurityPermissionPropertiesBinding.setSecurityPermissionSpec((ISecurityPermission)this.property().element(), spec);
    }

    private static SecurityPermissionSpec getSecurityPermissionSpec(ISecurityPermission sp) {
        Matcher matcher;
        XmlElement el = ((XmlResource)sp.adapt(XmlResource.class)).getXmlElement(false);
        String str = el == null ? null : el.getChildNodeText(PATH_SECURITY_PERMISSION_SPEC);
        String className = null;
        String target = null;
        String actions = null;
        if (str != null && (matcher = PARSING_PATTERN.matcher(str)).find()) {
            className = matcher.group(1);
            target = matcher.group(2);
            actions = matcher.group(3);
        }
        return new SecurityPermissionSpec(className, target, actions);
    }

    private static void setSecurityPermissionSpec(ISecurityPermission sp, SecurityPermissionSpec securityPermissionSpec) {
        String value = securityPermissionSpec.isEmpty() ? null : securityPermissionSpec.toString();
        ((XmlResource)sp.adapt(XmlResource.class)).getXmlElement(true).setChildNodeText(PATH_SECURITY_PERMISSION_SPEC, value, true);
    }

    private static final class SecurityPermissionSpec {
        private String className;
        private String target;
        private String actions;

        public SecurityPermissionSpec(String className, String target, String actions) {
            this.className = className;
            this.target = target;
            this.actions = actions;
        }

        public boolean isEmpty() {
            return this.className == null && this.target == null && this.actions == null;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }

        public String getActions() {
            return this.actions;
        }

        public void setActions(String actions) {
            this.actions = actions;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("grant { permission ");
            buf.append(this.toString(this.className));
            buf.append(" \"");
            buf.append(this.toString(this.target));
            buf.append("\", \"");
            buf.append(this.toString(this.actions));
            buf.append("\" };");
            return buf.toString();
        }

        private String toString(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj.toString();
        }
    }
}

