/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.internal;

import oracle.eclipse.tools.weblogic.descriptors.ICapacityConstraint;
import oracle.eclipse.tools.weblogic.descriptors.ICapacityConstraintReference;
import oracle.eclipse.tools.weblogic.descriptors.IContextRequestClass;
import oracle.eclipse.tools.weblogic.descriptors.IFairShareRequestClass;
import oracle.eclipse.tools.weblogic.descriptors.IMaximumThreadsConstraint;
import oracle.eclipse.tools.weblogic.descriptors.IMaximumThreadsConstraintReference;
import oracle.eclipse.tools.weblogic.descriptors.IMinimumThreadsConstraint;
import oracle.eclipse.tools.weblogic.descriptors.IMinimumThreadsConstraintReference;
import oracle.eclipse.tools.weblogic.descriptors.IRequestClassReference;
import oracle.eclipse.tools.weblogic.descriptors.IResponseTimeRequestClass;
import oracle.eclipse.tools.weblogic.descriptors.ISchedulingGuideline;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public final class SchedulingGuidelinesValidator
extends ValidationService {
    protected Status compute() {
        ElementList guidelines = (ElementList)this.context(ElementList.of(ISchedulingGuideline.class));
        boolean requestClassGuidelineFound = false;
        boolean minThreadsConstraintFound = false;
        boolean maxThreadsConstraintFound = false;
        boolean capacityConstraintFound = false;
        for (ISchedulingGuideline guideline : guidelines) {
            if (guideline instanceof IResponseTimeRequestClass || guideline instanceof IFairShareRequestClass || guideline instanceof IContextRequestClass || guideline instanceof IRequestClassReference) {
                if (requestClassGuidelineFound) {
                    return Status.createErrorStatus((String)Resources.multipleRequestClassGuidelinesNotAllowed);
                }
                requestClassGuidelineFound = true;
                continue;
            }
            if (guideline instanceof IMinimumThreadsConstraint || guideline instanceof IMinimumThreadsConstraintReference) {
                if (minThreadsConstraintFound) {
                    return Status.createErrorStatus((String)Resources.multipleMinThreadsConstraintsNotAllowed);
                }
                minThreadsConstraintFound = true;
                continue;
            }
            if (guideline instanceof IMaximumThreadsConstraint || guideline instanceof IMaximumThreadsConstraintReference) {
                if (maxThreadsConstraintFound) {
                    return Status.createErrorStatus((String)Resources.multipleMaxThreadsConstraintsNotAllowed);
                }
                maxThreadsConstraintFound = true;
                continue;
            }
            if (!(guideline instanceof ICapacityConstraint) && !(guideline instanceof ICapacityConstraintReference)) continue;
            if (capacityConstraintFound) {
                return Status.createErrorStatus((String)Resources.multipleCapacityConstraintsNotAllowed);
            }
            capacityConstraintFound = true;
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String multipleRequestClassGuidelinesNotAllowed;
        public static String multipleMinThreadsConstraintsNotAllowed;
        public static String multipleMaxThreadsConstraintsNotAllowed;
        public static String multipleCapacityConstraintsNotAllowed;

        static {
            Resources.initializeMessages((String)SchedulingGuidelinesValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

