/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.internal;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import oracle.eclipse.tools.weblogic.descriptors.ILibraryRef;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.services.PossibleValuesService;

public final class ReferencedSharedLibraryContextRootValuesProvider
extends PossibleValuesService {
    protected void fillPossibleValues(Set<String> values) {
        IWebLogicAppDescriptor descriptor = (IWebLogicAppDescriptor)this.context(IWebLogicAppDescriptor.class);
        values.addAll(ReferencedSharedLibraryContextRootValuesProvider.getLibraryContextRoots(descriptor));
    }

    private static Set<String> getLibraryContextRoots(IWebLogicAppDescriptor descriptor) {
        TreeSet<String> result = new TreeSet<String>();
        for (ILibraryRef libref : descriptor.getLibraryRefs()) {
            String contextRoot;
            LibraryModule lib;
            try {
                lib = LibraryModulesSvc.resolve(LibraryModulesSvc.convert(libref));
            }
            catch (CoreException coreException) {
                continue;
            }
            LibraryModule.Type type = lib.getType();
            if (type == LibraryModule.Type.EAR) {
                try {
                    File tempExplodedRoot = lib.explode();
                    File libraryDescriptorFile = new File(tempExplodedRoot, "META-INF/weblogic-application.xml");
                    if (!libraryDescriptorFile.exists()) continue;
                    IWebLogicAppDescriptor libraryDescriptor = WebLogicDescriptorFactory.getAppDescriptor(libraryDescriptorFile);
                    result.addAll(ReferencedSharedLibraryContextRootValuesProvider.getLibraryContextRoots(libraryDescriptor));
                    libraryDescriptor.dispose();
                }
                catch (IOException e) {
                    WlsCorePlugin.logException(e);
                }
                continue;
            }
            if (type != LibraryModule.Type.WAR || (contextRoot = libref.getContextRoot().text(false)) == null) continue;
            result.add(contextRoot);
        }
        return result;
    }
}

