/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.internal;

import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.descriptors.IModuleDefinition;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.ModuleType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class ModuleTypeValidator
extends ValidationService {
    protected Status compute() {
        Value value = (Value)this.context(Value.of(ModuleType.class));
        ModuleType type = (ModuleType)((Object)value.content(false));
        if (type == ModuleType.GAR) {
            IWebLogicAppDescriptor descriptor = (IWebLogicAppDescriptor)value.nearest(IWebLogicAppDescriptor.class);
            WebLogicServerVersion version = WebLogicServerVersion.convert((Version)descriptor.getServerVersion().content());
            if (version != null && version.compareTo(WebLogicServerVersion.VERSION_12_1_2) < 0) {
                return Status.createErrorStatus((String)Resources.onlyAvailableIn1212OrNewer);
            }
            ElementList list = (ElementList)value.element().parent();
            if (list.isEmpty()) {
                return Status.createOkStatus();
            }
            boolean foundGarModule = false;
            for (Element module : list) {
                ModuleType type1 = (ModuleType)((Object)((IModuleDefinition)module).getType().content());
                if (type1 != ModuleType.GAR) continue;
                if (foundGarModule) {
                    return Status.createErrorStatus((String)"Only one GAR module is permitted within an EAR");
                }
                foundGarModule = true;
            }
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String onlyAvailableIn1212OrNewer;

        static {
            Resources.initializeMessages((String)ModuleTypeValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

