/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.internal;

import java.util.Set;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicWebModuleDescriptor;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.core.EjbRef;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.services.PossibleValuesService;

public final class EjbReferenceNameValuesProvider
extends PossibleValuesService {
    protected void fillPossibleValues(Set<String> values) {
        IModelProvider modelProvider;
        Element descriptor = ((Element)this.context(Element.class)).root();
        IProject project = (IProject)descriptor.adapt(IProject.class);
        if (project != null && (modelProvider = ModelProviderManager.getModelProvider((IProject)project)) != null) {
            Object model = modelProvider.getModelObject();
            if (model instanceof WebApp) {
                WebApp webApp = (WebApp)model;
                for (EjbRef ejbRef : webApp.getEjbRefs()) {
                    String ejbRefName = ejbRef.getEjbRefName();
                    if (ejbRefName == null) continue;
                    values.add(ejbRefName);
                }
            } else if (model instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)model;
                for (org.eclipse.jst.j2ee.common.EjbRef ejbRef : webApp.getEjbRefs()) {
                    String ejbRefName = ejbRef.getName();
                    if (ejbRefName == null) continue;
                    values.add(ejbRefName);
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }

    public String getInvalidValueMessage(String invalidValue) {
        String msg = this.context(IWebLogicWebModuleDescriptor.class) != null ? Resources.bind((String)Resources.invalidValueMessageForWeb, (Object)invalidValue) : Resources.bind((String)Resources.invalidValueMessageForEjb, (Object)invalidValue);
        return msg;
    }

    private static final class Resources
    extends NLS {
        public static String invalidValueMessageForWeb;
        public static String invalidValueMessageForEjb;

        static {
            Resources.initializeMessages((String)EjbReferenceNameValuesProvider.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

