/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.weblogic.descriptors.IClassLoaderStructure;
import oracle.eclipse.tools.weblogic.descriptors.IModuleRef;
import org.eclipse.sapphire.ElementList;

public final class ClassLoaderStructureMethods {
    public static IClassLoaderStructure getRootClassLoaderStructure(IModuleRef moduleRef) {
        IClassLoaderStructure cl = null;
        IModuleRef temp = moduleRef;
        while (temp instanceof IModuleRef || temp instanceof IClassLoaderStructure) {
            if (temp instanceof IClassLoaderStructure) {
                cl = (IClassLoaderStructure)((Object)temp);
            }
            temp = temp.parent().element();
        }
        return cl;
    }

    public static List<IModuleRef> getModuleRefs(IClassLoaderStructure cl, String uri) {
        ArrayList<IModuleRef> result = new ArrayList<IModuleRef>(1);
        for (IModuleRef moduleRef : cl.getModuleRefs()) {
            String moduleRefUri = moduleRef.getModuleUri().text();
            if (!uri.equals(moduleRefUri)) continue;
            result.add(moduleRef);
        }
        for (IClassLoaderStructure childClassLoaderStructure : cl.getChildClassLoaderStructures()) {
            result.addAll(childClassLoaderStructure.getModuleRefs(uri));
        }
        return result;
    }

    public static int getNestingDepth(IClassLoaderStructure cl) {
        if (cl.parent() instanceof ElementList) {
            return ((IClassLoaderStructure)cl.parent().element()).getNestingDepth() + 1;
        }
        return 1;
    }
}

