/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.internal;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.weblogic.descriptors.IApplicationParam;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.PossibleValuesService;

public final class ApplicationParamValueValuesProvider
extends PossibleValuesService {
    private static final List<String> BOOLEAN_VALUES;
    private Listener listener;
    private static final List<String> CHARACTER_ENCODING_VALUES;

    static {
        ArrayList<String> list = new ArrayList<String>();
        list.add("true");
        list.add("false");
        BOOLEAN_VALUES = Collections.unmodifiableList(list);
        list = new ArrayList();
        for (String charset : Charset.availableCharsets().keySet()) {
            list.add(charset);
        }
        CHARACTER_ENCODING_VALUES = Collections.unmodifiableList(list);
    }

    protected void init() {
        super.init();
        this.listener = new Listener(){

            public void handle(Event event) {
                ApplicationParamValueValuesProvider.this.broadcast();
            }
        };
        IWebLogicAppDescriptor appDesc = (IWebLogicAppDescriptor)this.context(IWebLogicAppDescriptor.class);
        appDesc.attach(this.listener, "ApplicationParams/Name");
    }

    protected void fillPossibleValues(Set<String> values) {
        IApplicationParam param = (IApplicationParam)this.context(IApplicationParam.class);
        String name = param.getName().text();
        if (name != null) {
            if (name.equals("webapp.encoding.default")) {
                values.addAll(CHARACTER_ENCODING_VALUES);
            } else if (name.equals("webapp.encoding.usevmdefault") || name.equals("webapp.getrealpath.accept_context_path")) {
                values.addAll(BOOLEAN_VALUES);
            }
        }
    }

    public String getInvalidValueMessage(String invalidValue) {
        IApplicationParam param = (IApplicationParam)this.context(IApplicationParam.class);
        String name = param.getName().text();
        if (name != null) {
            if (name.equals("webapp.encoding.default")) {
                return Resources.invalidValueMessageDefaultEncoding;
            }
            if (name.equals("webapp.encoding.usevmdefault") || name.equals("webapp.getrealpath.accept_context_path")) {
                return NLS.bind((String)Resources.invalidValueMessageBoolean, (Object)name);
            }
        }
        return "";
    }

    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        IApplicationParam param = (IApplicationParam)this.context(IApplicationParam.class);
        String name = param.getName().text();
        if (name != null && (name.equals("webapp.encoding.default") || name.equals("webapp.encoding.usevmdefault") || name.equals("webapp.getrealpath.accept_context_path"))) {
            return Status.Severity.ERROR;
        }
        return Status.Severity.OK;
    }

    public void dispose() {
        if (this.listener != null) {
            IWebLogicAppDescriptor appDesc = (IWebLogicAppDescriptor)this.context(IWebLogicAppDescriptor.class);
            appDesc.detach(this.listener, "ApplicationParams/Name");
        }
        super.dispose();
    }

    private static final class Resources
    extends NLS {
        public static String invalidValueMessageDefaultEncoding;
        public static String invalidValueMessageBoolean;

        static {
            Resources.initializeMessages((String)ApplicationParamValueValuesProvider.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

