/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IMethod;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.MethodIntf;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal.BaseEjbJarValuesProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.common.operations.JavaModelUtil;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;

public final class MethodValuesProvider
extends BaseEjbJarValuesProvider {
    private static final String LOCAL_BEAN = "LocalBean";
    private static final String EXCEPTION_1 = "java.io.Serializable";
    private static final String EXCEPTION_2 = "java.io.Externalizable";
    private static final String EXCEPTION_PACKAGE = "javax.ejb";
    private Listener listener;

    @Override
    protected void init() {
        super.init();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                MethodValuesProvider.this.broadcast();
            }
        };
        IMethod method = (IMethod)this.context(IMethod.class);
        if (method != null) {
            method.getEjbName().attach(this.listener);
            method.getMethodIntf().attach(this.listener);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        IMethod method = (IMethod)this.context(IMethod.class);
        if (method != null && !method.disposed()) {
            method.getEjbName().detach(this.listener);
            method.getMethodIntf().detach(this.listener);
        }
    }

    protected void fillPossibleValues(Set<String> values) {
        for (org.eclipse.jdt.core.IMethod method : MethodValuesProvider.getAllMethods((IMethod)this.context(IMethod.class))) {
            values.add(MethodValuesProvider.getMethodString(method));
        }
        values.add("*");
    }

    public static String getMethodString(org.eclipse.jdt.core.IMethod method) {
        StringBuffer buf = new StringBuffer();
        try {
            buf.append(method.getElementName());
            buf.append('(');
            if (method.getNumberOfParameters() > 0) {
                String[] parameterTypes = method.getParameterTypes();
                String[] types = new String[parameterTypes.length];
                int i = 0;
                while (i < parameterTypes.length) {
                    IType type = method.getDeclaringType();
                    types[i] = JavaModelUtil.getResolvedTypeName((String)parameterTypes[i], (IType)type);
                    int arrayCount = Signature.getArrayCount((String)parameterTypes[i]);
                    if (arrayCount > 0) {
                        StringBuffer buf2 = new StringBuffer(types[i]);
                        int j = 0;
                        while (j < arrayCount) {
                            buf2.append("[]");
                            ++j;
                        }
                        types[i] = buf2.toString();
                    }
                    ++i;
                }
                buf.append(StringUtil.join((String[])types, (char)','));
            }
            buf.append(')');
        }
        catch (JavaModelException javaModelException) {}
        return buf.toString();
    }

    public static List<org.eclipse.jdt.core.IMethod> getAllMethods(IMethod method) {
        ArrayList<org.eclipse.jdt.core.IMethod> methods = new ArrayList<org.eclipse.jdt.core.IMethod>();
        String ejbName = method.getEjbName().text();
        String intfStr = method.getMethodIntf().text();
        if (ejbName != null && intfStr != null) {
            EJBJar ejbjar;
            EnterpriseBeans beans;
            MethodIntf intf = MethodIntf.valueOf(intfStr.toUpperCase());
            Object model = MethodValuesProvider.getModel(method);
            if (model instanceof org.eclipse.jst.j2ee.ejb.EJBJar) {
                org.eclipse.jst.j2ee.ejb.EJBJar ejbjar2 = (org.eclipse.jst.j2ee.ejb.EJBJar)model;
                EnterpriseBean bean = ejbjar2.getEnterpriseBeanNamed(ejbName);
                if (bean != null && intf != null) {
                    String className;
                    switch (intf) {
                        case HOME: {
                            className = bean.getHomeInterfaceName();
                            break;
                        }
                        case REMOTE: {
                            className = bean.getRemoteInterfaceName();
                            break;
                        }
                        case LOCAL: {
                            className = bean.getLocalInterfaceName();
                            break;
                        }
                        case LOCALHOME: {
                            className = bean.getLocalHomeInterfaceName();
                            break;
                        }
                        default: {
                            className = null;
                        }
                    }
                    MethodValuesProvider.appendMethod((IProject)method.adapt(IProject.class), className, methods);
                }
            } else if (model instanceof EJBJar && (beans = (ejbjar = (EJBJar)model).getEnterpriseBeans()) != null) {
                String className;
                MessageDrivenBean MDBean;
                Object obj2;
                for (Object obj2 : beans.getEntityBeans()) {
                    EntityBean entityBean = (EntityBean)obj2;
                    if (!ejbName.equals(entityBean.getEjbName())) continue;
                    if (intf == null) break;
                    switch (intf) {
                        case HOME: {
                            MethodValuesProvider.appendMethod((IProject)method.adapt(IProject.class), entityBean.getHome(), methods);
                            break;
                        }
                        case REMOTE: {
                            MethodValuesProvider.appendMethod((IProject)method.adapt(IProject.class), entityBean.getRemote(), methods);
                            break;
                        }
                        case LOCAL: {
                            MethodValuesProvider.appendMethod((IProject)method.adapt(IProject.class), entityBean.getLocal(), methods);
                            break;
                        }
                        case LOCALHOME: {
                            MethodValuesProvider.appendMethod((IProject)method.adapt(IProject.class), entityBean.getLocalHome(), methods);
                            break;
                        }
                    }
                    break;
                }
                Iterator iterator = beans.getSessionBeans().iterator();
                block19: while (iterator.hasNext()) {
                    obj2 = iterator.next();
                    SessionBean sessionBean = (SessionBean)obj2;
                    if (!ejbName.equals(sessionBean.getEjbName())) continue;
                    if (intf == null) break;
                    switch (intf) {
                        case HOME: {
                            MethodValuesProvider.appendMethod((IProject)method.adapt(IProject.class), sessionBean.getHome(), methods);
                            break;
                        }
                        case REMOTE: {
                            MethodValuesProvider.appendMethod((IProject)method.adapt(IProject.class), sessionBean.getRemote(), methods);
                            MethodValuesProvider.appendMethod((IProject)method.adapt(IProject.class), sessionBean.getBusinessRemotes(), methods);
                            break;
                        }
                        case LOCAL: {
                            MethodValuesProvider.appendMethod((IProject)method.adapt(IProject.class), sessionBean.getLocal(), methods);
                            MethodValuesProvider.appendMethod((IProject)method.adapt(IProject.class), sessionBean.getBusinessLocals(), methods);
                            if (!MethodValuesProvider.noInterface((IProject)method.adapt(IProject.class), sessionBean)) break block19;
                            MethodValuesProvider.appendMethod((IProject)method.adapt(IProject.class), sessionBean.getEjbClass(), methods);
                            break;
                        }
                        case LOCALHOME: {
                            MethodValuesProvider.appendMethod((IProject)method.adapt(IProject.class), sessionBean.getLocalHome(), methods);
                            break;
                        }
                    }
                    break;
                }
                if ((iterator = beans.getMessageDrivenBeans().iterator()).hasNext() && ejbName.equals((MDBean = (MessageDrivenBean)(obj2 = iterator.next())).getEjbName()) && intf != null && (className = MDBean.getEjbClass()) != null) {
                    MethodValuesProvider.appendMethod((IProject)method.adapt(IProject.class), className, methods);
                }
            }
        }
        return methods;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean noInterface(IProject project, SessionBean sessionBean) {
        try {
            String ejbClass = sessionBean.getEjbClass();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IType type = null;
            if (javaProject != null && javaProject.exists()) {
                IAnnotation annotation;
                type = javaProject.findType(ejbClass);
                if (type != null) {
                    if (!type.exists()) return false;
                    if (type.isAnonymous()) {
                        return false;
                    }
                }
                if (type != null && (annotation = type.getAnnotation(LOCAL_BEAN)) != null && annotation.exists()) {
                    return true;
                }
            }
            if (type == null) return false;
            String local = sessionBean.getLocal();
            if (local != null && local.length() > 0) {
                return false;
            }
            List businessLocals = sessionBean.getBusinessLocals();
            if (businessLocals != null && businessLocals.size() > 0) {
                return false;
            }
            String home = sessionBean.getHome();
            if (home != null && home.length() > 0) {
                return false;
            }
            String remote = sessionBean.getRemote();
            if (remote != null && remote.length() > 0) {
                return false;
            }
            List businessRemotes = sessionBean.getBusinessRemotes();
            if (businessRemotes != null && businessRemotes.size() > 0) {
                return false;
            }
            String localHome = sessionBean.getLocalHome();
            if (localHome != null && localHome.length() > 0) {
                return false;
            }
            String[] stringArray = type.getSuperInterfaceNames();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                String iName = stringArray[n2];
                if (!(iName.equals(EXCEPTION_1) || iName.equals(EXCEPTION_2) || iName.startsWith(EXCEPTION_PACKAGE))) {
                    return false;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    private static void appendMethod(IProject project, List<String> classNames, List<org.eclipse.jdt.core.IMethod> methods) {
        if (classNames == null || classNames.size() == 0) {
            return;
        }
        for (String className : classNames) {
            MethodValuesProvider.appendMethod(project, className, methods);
        }
    }

    private static void appendMethod(IProject project, String className, List<org.eclipse.jdt.core.IMethod> methods) {
        if (className == null || className.length() == 0) {
            return;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null || !javaProject.exists()) {
            return;
        }
        IType type = null;
        try {
            type = javaProject.findType(className);
            if (type != null && (!type.exists() || type.isAnonymous())) {
                type = null;
            }
            if (type != null) {
                org.eclipse.jdt.core.IMethod[] iMethodArray = type.getMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    org.eclipse.jdt.core.IMethod method = iMethodArray[n2];
                    if (!method.isConstructor() && Flags.isPublic((int)method.getFlags())) {
                        methods.add(method);
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public String getInvalidValueMessage(String invalidValue) {
        IMethod method = (IMethod)this.context(IMethod.class);
        String ejbName = method.getEjbName().text();
        if (ejbName == null || ejbName.length() == 0) {
            return Resources.ejbNameMissing;
        }
        String intfStr = method.getMethodIntf().text();
        if (intfStr == null || intfStr.length() == 0) {
            return Resources.methodIntfMissing;
        }
        Object[] params = new String[]{invalidValue, ejbName, intfStr};
        return Resources.bind((String)Resources.invalidValueMessage, (Object[])params);
    }

    private static final class Resources
    extends NLS {
        public static String ejbNameMissing;
        public static String methodIntfMissing;
        public static String invalidValueMessage;

        static {
            Resources.initializeMessages((String)MethodValuesProvider.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

