/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal;

import java.util.List;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public final class DisableWarningBinding
extends XmlValueBindingImpl {
    private static final String DISABLE_WARNING = "disable-warning";
    private String code;

    public void init(Property property) {
        super.init(property);
        this.code = ((CustomXmlValueBinding)property.definition().getAnnotation(CustomXmlValueBinding.class)).params()[0];
    }

    public String read() {
        XmlElement el = this.xml(false);
        if (el != null) {
            List warnings = el.getChildElements(DISABLE_WARNING);
            for (XmlElement warning : warnings) {
                if (!this.code.equals(warning.getText())) continue;
                return Boolean.FALSE.toString();
            }
        }
        return null;
    }

    public void write(String value) {
        XmlElement el = this.xml(true);
        if (el != null) {
            if (value != null && Boolean.valueOf(value) == Boolean.FALSE) {
                XmlElement child = el.addChildElement(DISABLE_WARNING);
                child.setText(this.code);
            } else {
                List warnings = el.getChildElements(DISABLE_WARNING);
                for (XmlElement warning : warnings) {
                    if (!this.code.equals(warning.getText())) continue;
                    warning.remove();
                }
            }
        }
    }

    public XmlNode getXmlNode() {
        XmlElement el = this.xml(false);
        if (el != null) {
            List warnings = el.getChildElements(DISABLE_WARNING);
            for (XmlElement warning : warnings) {
                if (!this.code.equals(warning.getText())) continue;
                return warning;
            }
        }
        return null;
    }
}

