/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.ejbjar;

import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IEjbJarEjbReferenceDescription;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IEjbJarResourceEnvReferenceDescription;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IEjbJarResourceReferenceDescription;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IEjbJarServiceReference;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IIiopSecurityDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IJndiBinding;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.ITransactionDescriptor;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

@Label(standard="Weblogic Enterprise Bean")
@Image(path="images/descriptors/ejb/bean.png")
public interface IWeblogicEnterpriseBean
extends Element,
IIiopSecurityDescriptor,
ITransactionDescriptor {
    public static final ElementType TYPE = new ElementType(IWeblogicEnterpriseBean.class);
    public static final String PNAME_EJB_NAME = "EjbName";
    @XmlBinding(path="ejb-name")
    @Label(standard="EJB name")
    @Required
    @Documentation(content="Specifies an enterprise bean's name, using the same name for the bean that is specified in the ejb-jar.xml file.")
    public static final ValueProperty PROP_EJB_NAME = new ValueProperty(TYPE, "EjbName");
    @Type(base=Boolean.class)
    @XmlBinding(path="enable-call-by-reference")
    @Label(standard="enable call by reference")
    @DefaultValue(text="false")
    @Documentation(content="When set to \"false\", parameters to the EJB methods are copied or passed by value regardless of whether the EJB bean is called remotely or from within the same EAR.[pbr/]When set to \"true\", EJB methods called from within the same EAR file or standalone JAR file will pass arguments by reference. This improves the performance of method invocation since parameters are not copied.[pbr/]Note: Method parameters are always passed by value when an EJB bean is called remotely.")
    public static final ValueProperty PROP_ENABLE_CALL_BY_REFERENCE = new ValueProperty(TYPE, "EnableCallByReference");
    @XmlBinding(path="network-access-point")
    @Label(standard="network access point")
    @Documentation(content="Assigns a custom network channel that the EJB will use for network communications. A network channel defines a set of connection attributes.")
    public static final ValueProperty PROP_NETWORK_ACCESS_POINT = new ValueProperty(TYPE, "NetworkAccessPoint");
    @Type(base=Boolean.class)
    @XmlBinding(path="clients-on-same-server")
    @Label(standard="clients on the same server")
    @DefaultValue(text="false")
    @Documentation(content="Determines whether or not Oracle WebLogic Server sends JNDI announcements for this EJB bean when it is deployed. When this attribute is \"Fals\"e (the default), Oracle WebLogic Server cluster automatically updates its JNDI tree to indicate the location of this EJB bean on a particular server. This ensures that all clients can access the EJB bean, even if the client is not collocated on the same server.[pbr/]You can set \"clients-on-same-server\" to \"True\" when you know that all clients that will access this EJB bean will do so from the same server on which the bean is deployed. In this case, an Oracle WebLogic Server cluster does not send JNDI announcements for this EJB bean when it is deployed. Because JNDI updates in a cluster utilize multicast traffic, setting \"clients-on-same-server\" to \"True\" can reduce the startup time for very large clusters.")
    public static final ValueProperty PROP_CLIENTS_ON_SAME_SERVER = new ValueProperty(TYPE, "ClientsOnSameServer");
    @XmlBinding(path="run-as-principal-name")
    @Label(standard="run as principal name")
    @Documentation(content="Specifies which security principal name is to be used as the run-as principal for a bean that has specified a security-identity run-as role-name in its ejb-jar.xml deployment descriptor.")
    public static final ValueProperty PROP_RUN_AS_PRINCIPAL_NAME = new ValueProperty(TYPE, "RunAsPrincipalName");
    @XmlBinding(path="create-as-principal-name")
    @Label(standard="create as principal name")
    @Documentation(content="Specifies which security principal name is to be used as the run-as principal for a bean that has specified a security-identity run-as role-name in its ejb-jar.xml deployment descriptor.")
    public static final ValueProperty PROP_CREATE_AS_PRINCIPAL_NAME = new ValueProperty(TYPE, "CreateAsPrincipalName");
    @XmlBinding(path="remove-as-principal-name")
    @Label(standard="remove as principal name")
    @Documentation(content="Specifies the principal to be used in situations where ejbRemove would otherwise run with an anonymous principal. The \"remove-as-principal-name\" element only needs to be specified if operations within ejbRemove require more permissions than the anonymous principal would have.")
    public static final ValueProperty PROP_REMOVE_AS_PRINCIPAL_NAME = new ValueProperty(TYPE, "RemoveAsPrincipalName");
    @XmlBinding(path="passivate-as-principal-name")
    @Label(standard="passivate as principal name")
    @Documentation(content="Specifies the principal to be used in situations where ejbPassivate would otherwise run with an anonymous principal. The \"passivate-as-principal-name\" element only needs to be specified if operations within ejbPassivate require more permissions than the anonymous principal would have.")
    public static final ValueProperty PROP_PASSIVATE_AS_PRINCIPAL_NAME = new ValueProperty(TYPE, "PassivateAsPrincipalName");
    @XmlBinding(path="jndi-name")
    @Label(standard="JNDI name")
    @Documentation(content="Specifies the JNDI name of an actual EJB bean available in Oracle WebLogic Server.")
    public static final ValueProperty PROP_JNDI_NAME = new ValueProperty(TYPE, "JndiName");
    @XmlBinding(path="local-jndi-name")
    @Label(standard="local JNDI name")
    @Documentation(content="Specifies the JNDI name for a bean\u2019s local home.")
    public static final ValueProperty PROP_LOCAL_JNDI_NAME = new ValueProperty(TYPE, "LocalJndiName");
    @XmlBinding(path="dispatch-policy")
    @Label(standard="dispatch policy")
    @Documentation(content="Specifies the thread pool used to handle requests to the bean.")
    public static final ValueProperty PROP_DISPATCH_POLICY = new ValueProperty(TYPE, "DispatchPolicy");
    @Type(base=Integer.class)
    @XmlBinding(path="remote-client-timeout")
    @Label(standard="remote client timeout (secs)")
    @NumericRange(min="0")
    @DefaultValue(text="0")
    @Documentation(content="Specifies the length of time in seconds that a remote RMI client will wait before it will time out.")
    public static final ValueProperty PROP_REMOTE_CLIENT_TIMEOUT = new ValueProperty(TYPE, "RemoteClientTimeout");
    @Type(base=Boolean.class)
    @XmlBinding(path="stick-to-first-server")
    @Label(standard="stick to first server ")
    @DefaultValue(text="false")
    @Since(value="10.0")
    @Documentation(content="When set to \"true\", the server chosen for servicing the first request is used for all subsequent requests.")
    public static final ValueProperty PROP_STICK_TO_FIRST_SERVER = new ValueProperty(TYPE, "StickToFirstServer");
    @Type(base=IEjbJarEjbReferenceDescription.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="ejb-reference-description", type=IEjbJarEjbReferenceDescription.class)})
    public static final ListProperty PROP_EJB_REFERENCE_DESCRIPTIONS = new ListProperty(TYPE, "EjbReferenceDescriptions");
    @Type(base=IEjbJarResourceReferenceDescription.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="resource-description", type=IEjbJarResourceReferenceDescription.class)})
    public static final ListProperty PROP_RESOURCE_REFERENCES = new ListProperty(TYPE, "ResourceReferences");
    @Type(base=IEjbJarResourceEnvReferenceDescription.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="resource-env-description", type=IEjbJarResourceEnvReferenceDescription.class)})
    public static final ListProperty PROP_RESOURCE_ENV_REFERENCES = new ListProperty(TYPE, "ResourceEnvReferences");
    @Type(base=IEjbJarServiceReference.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="service-reference-description", type=IEjbJarServiceReference.class)})
    public static final ListProperty PROP_SERVICE_REFERENCES = new ListProperty(TYPE, "ServiceReferences");
    @Type(base=IJndiBinding.class)
    @Label(standard="JNDI bindings")
    @Since(value="12.1.1")
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="jndi-binding", type=IJndiBinding.class)})
    public static final ListProperty PROP_JNDI_BINDINGS = new ListProperty(TYPE, "JndiBindings");

    public Value<String> getEjbName();

    public void setEjbName(String var1);

    public Value<Boolean> getEnableCallByReference();

    public void setEnableCallByReference(String var1);

    public void setEnableCallByReference(Boolean var1);

    public Value<String> getNetworkAccessPoint();

    public void setNetworkAccessPoint(String var1);

    public Value<Boolean> getClientsOnSameServer();

    public void setClientsOnSameServer(String var1);

    public void setClientsOnSameServer(Boolean var1);

    public Value<String> getRunAsPrincipalName();

    public void setRunAsPrincipalName(String var1);

    public Value<String> getCreateAsPrincipalName();

    public void setCreateAsPrincipalName(String var1);

    public Value<String> getRemoveAsPrincipalName();

    public void setRemoveAsPrincipalName(String var1);

    public Value<String> getPassivateAsPrincipalName();

    public void setPassivateAsPrincipalName(String var1);

    public Value<String> getJndiName();

    public void setJndiName(String var1);

    public Value<String> getLocalJndiName();

    public void setLocalJndiName(String var1);

    public Value<String> getDispatchPolicy();

    public void setDispatchPolicy(String var1);

    public Value<Integer> getRemoteClientTimeout();

    public void setRemoteClientTimeout(String var1);

    public void setRemoteClientTimeout(Integer var1);

    public Value<Boolean> getStickToFirstServer();

    public void setStickToFirstServer(String var1);

    public void setStickToFirstServer(Boolean var1);

    public ElementList<IEjbJarEjbReferenceDescription> getEjbReferenceDescriptions();

    public ElementList<IEjbJarResourceReferenceDescription> getResourceReferences();

    public ElementList<IEjbJarResourceEnvReferenceDescription> getResourceEnvReferences();

    public ElementList<IEjbJarServiceReference> getServiceReferences();

    public ElementList<IJndiBinding> getJndiBindings();
}

