/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.ejbjar;

import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IClustering;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.LoadAlgorithm;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IStatelessClustering
extends IClustering {
    public static final ElementType TYPE = new ElementType(IStatelessClustering.class);
    @XmlBinding(path="stateless-clustering/home-is-clusterable")
    public static final ValueProperty PROP_HOME_IS_CLUSTERABLE = new ValueProperty(TYPE, IClustering.PROP_HOME_IS_CLUSTERABLE);
    @XmlBinding(path="stateless-clustering/home-load-algorithm")
    public static final ValueProperty PROP_HOME_LOAD_ALGORITHM = new ValueProperty(TYPE, IClustering.PROP_HOME_LOAD_ALGORITHM);
    @XmlBinding(path="stateless-clustering/home-call-router-class-name")
    public static final ValueProperty PROP_HOME_CALL_ROUTER_CLASS_NAME = new ValueProperty(TYPE, IClustering.PROP_HOME_CALL_ROUTER_CLASS_NAME);
    @XmlBinding(path="stateless-clustering/use-serverside-stubs")
    public static final ValueProperty PROP_USE_SERVERSIDE_STUBS = new ValueProperty(TYPE, IClustering.PROP_USE_SERVERSIDE_STUBS);
    @Type(base=Boolean.class)
    @XmlBinding(path="stateless-clustering/stateless-bean-is-clusterable")
    @Label(standard="stateless bean is clusterable")
    @DefaultValue(text="true")
    @Documentation(content="When set to \"true\", the EJB bean can be deployed from multiple Oracle WebLogic Servers in a cluster.")
    public static final ValueProperty PROP_STATELESS_BEAN_IS_CLUSTERABLE = new ValueProperty(TYPE, "StatelessBeanIsClusterable");
    @Type(base=LoadAlgorithm.class)
    @XmlBinding(path="stateless-clustering/stateless-bean-load-algorithm")
    @Label(standard="stateless bean load algorithm")
    @DefaultValue(text="round-robin")
    @Enablement(expr="${ StatelessBeanIsClusterable }")
    @Documentation(content="Specifies the algorithm to use for load balancing between replicas of the EJB home.[ul][li]round-robin: Load balancing is performed in a sequential fashion among the servers hosting the bean.[/li][li]random: Replicas of the EJB home are deployed randomly among the servers hosting the bean.[/li][li]weight-based: Replicas of the EJB home are deployed on host servers according to the server\u2019s current workload.[/li][li]round-robin-affinity: Server affinity governs connections between external Java clients and server instances; round robin load balancing is used for connections between server instances.[/li][li]weight-based-affinity: Server affinity governs connections between external Java clients and server instances; weight-based load balancing is used for connections between server instances.[/li][li]random-affinity: Server affinity governs connections between external Java clients and server instances; random load balancing is used for connections between server instances.[/li][/ul]")
    public static final ValueProperty PROP_STATELESS_BEAN_LOAD_ALGORITHM = new ValueProperty(TYPE, "StatelessBeanLoadAlgorithm");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @XmlBinding(path="stateless-clustering/stateless-bean-call-router-class-name")
    @Label(standard="stateless bean call router")
    @Enablement(expr="${ StatelessBeanIsClusterable }")
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"weblogic.rmi.cluster.CallRouter"})
    @MustExist
    @Documentation(content="Specifies the name of a custom class to use for routing bean method calls.")
    public static final ValueProperty PROP_STATELESS_BEAN_CALL_ROUTER_CLASS_NAME = new ValueProperty(TYPE, "StatelessBeanCallRouterClassName");

    public Value<Boolean> getStatelessBeanIsClusterable();

    public void setStatelessBeanIsClusterable(String var1);

    public void setStatelessBeanIsClusterable(Boolean var1);

    public Value<LoadAlgorithm> getStatelessBeanLoadAlgorithm();

    public void setStatelessBeanLoadAlgorithm(String var1);

    public void setStatelessBeanLoadAlgorithm(LoadAlgorithm var1);

    public ReferenceValue<JavaTypeName, JavaType> getStatelessBeanCallRouterClassName();

    public void setStatelessBeanCallRouterClassName(String var1);

    public void setStatelessBeanCallRouterClassName(JavaTypeName var1);
}

