/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.ejbjar;

import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IBusinessInterfaceJndiNameMap;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IStatefulClustering;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IWeblogicEnterpriseBean;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal.DirectoryValidator;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal.EjbNameStatefulSessionValuesProvider;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.VersionCompatibility;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="stateful session bean")
@Image(path="images/descriptors/ejb/stateful-session-bean.png")
public interface IStatefulSession
extends IWeblogicEnterpriseBean {
    public static final ElementType TYPE = new ElementType(IStatefulSession.class);
    @Service(impl=EjbNameStatefulSessionValuesProvider.class)
    public static final ValueProperty PROP_EJB_NAME = new ValueProperty(TYPE, IWeblogicEnterpriseBean.PROP_EJB_NAME);
    @Type(base=IStatefulClustering.class)
    @XmlBinding(path="stateful-session-descriptor")
    public static final ImpliedElementProperty PROP_STATEFUL_CLUSTERING = new ImpliedElementProperty(TYPE, "StatefulClustering");
    @XmlBinding(path="stateful-session-descriptor/persistent-store-dir")
    @Label(standard="persistent store directory")
    @DefaultValue(text="pstore")
    @Service(impl=DirectoryValidator.class)
    @Documentation(content="Specifies a file system directory where Oracle WebLogic Server stores the state of passivated stateful session bean instances.")
    public static final ValueProperty PROP_PERSISTENT_STORE_DIR = new ValueProperty(TYPE, "PersistentStoreDir");
    @Type(base=Boolean.class)
    @XmlBinding(path="stateful-session-descriptor/allow-concurrent-calls")
    @Label(standard="allow concurrent calls")
    @DefaultValue(text="false")
    @VersionCompatibility(value="10.3.6]")
    @Documentation(content="Specifies whether or not a stateful session bean instance allows concurrent method calls.")
    public static final ValueProperty PROP_ALLOW_CONCURRENT_CALLS = new ValueProperty(TYPE, "AllowConcurrentCalls");
    @Type(base=Boolean.class)
    @XmlBinding(path="stateful-session-descriptor/allow-remove-during-transaction")
    @Label(standard="allow remove during transaction")
    @DefaultValue(text="false")
    @Documentation(content="Specifies that the remove method on a stateful session bean can be invoked within a transaction context.")
    public static final ValueProperty PROP_ALLOW_REMOVE_DURING_TRANSACTION = new ValueProperty(TYPE, "AllowRemoveDuringTransaction");
    @Type(base=IBusinessInterfaceJndiNameMap.class)
    @XmlBinding(path="stateful-session-descriptor/business-interface-jndi-name-map")
    @VersionCompatibility(value="[10.0-12.1.1)")
    public static final ElementProperty PROP_BUSINESS_INTERFACE_JNDI_NAME_MAP = new ElementProperty(TYPE, "BusinessInterfaceJndiNameMap");

    public IStatefulClustering getStatefulClustering();

    public Value<String> getPersistentStoreDir();

    public void setPersistentStoreDir(String var1);

    public Value<Boolean> getAllowConcurrentCalls();

    public void setAllowConcurrentCalls(String var1);

    public void setAllowConcurrentCalls(Boolean var1);

    public Value<Boolean> getAllowRemoveDuringTransaction();

    public void setAllowRemoveDuringTransaction(String var1);

    public void setAllowRemoveDuringTransaction(Boolean var1);

    public ElementHandle<IBusinessInterfaceJndiNameMap> getBusinessInterfaceJndiNameMap();
}

