/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.ejbjar;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IPool
extends Element {
    public static final ElementType TYPE = new ElementType(IPool.class);
    @Type(base=Integer.class)
    @XmlBinding(path="pool/max-beans-in-free-pool")
    @Label(standard="max beans in free pool")
    @NumericRange(min="0")
    @DefaultValue(text="1000")
    @Documentation(content="Specifies the size of the free pool of EJB beans. A free pool is maintained for every entity bean, stateless session bean, and message-driven bean class.")
    public static final ValueProperty PROP_MAX_BEANS_IN_FREE_POOL = new ValueProperty(TYPE, "MaxBeansInFreePool");
    @Type(base=Integer.class)
    @XmlBinding(path="pool/initial-beans-in-free-pool")
    @Label(standard="initial beans in free pool")
    @NumericRange(min="0")
    @DefaultValue(text="0")
    @Documentation(content="Oracle WebLogic Server populates the free pool with the specified number of bean instances for every bean class at startup. Populating the free pool in this way improves initial response time for the EJB bean, because initial requests for the bean can be satisfied without generating a new instance.")
    public static final ValueProperty PROP_INITIAL_BEANS_IN_FREE_POOL = new ValueProperty(TYPE, "InitialBeansInFreePool");
    @Type(base=Integer.class)
    @XmlBinding(path="pool/idle-timeout-seconds")
    @Label(standard="idle timeout (secs)")
    @NumericRange(min="1")
    @DefaultValue(text="600")
    @Documentation(content="Defines the maximum length of time an EJB bean should remain in the cache. After this time has elapsed, Oracle WebLogic Server removes the bean instance if the number of beans in cache approaches the limit of \"max-beans-in-cache\". The removed bean instances are passivated.")
    public static final ValueProperty PROP_IDLE_TIMEOUT_SECONDS = new ValueProperty(TYPE, "IdleTimeoutSeconds");

    public Value<Integer> getMaxBeansInFreePool();

    public void setMaxBeansInFreePool(String var1);

    public void setMaxBeansInFreePool(Integer var1);

    public Value<Integer> getInitialBeansInFreePool();

    public void setInitialBeansInFreePool(String var1);

    public void setInitialBeansInFreePool(Integer var1);

    public Value<Integer> getIdleTimeoutSeconds();

    public void setIdleTimeoutSeconds(String var1);

    public void setIdleTimeoutSeconds(Integer var1);
}

