/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.ejbjar;

import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IPersistenceUse;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal.CmpEntityEnabler;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IPersistence
extends Element {
    public static final ElementType TYPE = new ElementType(IPersistence.class);
    @XmlBinding(path="persistence/is-modified-method-name")
    @Label(standard="is modified method name")
    @Documentation(content="Specifies a method that Oracle WebLogic Server calls when the EJB bean is stored.")
    public static final ValueProperty PROP_IS_MODIFIED_METHOD_NAME = new ValueProperty(TYPE, "IsModifiedMethodName");
    @Type(base=Boolean.class)
    @XmlBinding(path="persistence/delay-updates-until-end-of-tx")
    @Label(standard="delay updates until end of transaction")
    @DefaultValue(text="true")
    @Documentation(content="Sets to \"true\" to update the persistent store of all beans in a transaction at the completion of the transaction.")
    public static final ValueProperty PROP_DELAY_UPDATES_UNTIL_END_OF_TX = new ValueProperty(TYPE, "DelayUpdatesUntilEndOfTx");
    @Type(base=Boolean.class)
    @XmlBinding(path="persistence/finders-load-bean")
    @Label(standard="finders load bean")
    @DefaultValue(text="true")
    @Service(impl=CmpEntityEnabler.class)
    @Documentation(content="When set to \"true\", Oracle WebLogic Server immediately loads the bean into the cache if a reference to a bean is returned by the finder. When set to \"false\", Oracle WebLogic Server does not automatically load the bean into the cache until the first method invocation.pbr/]Valid only for EJB 2.n entity beans with container-managed persistence.")
    public static final ValueProperty PROP_FINDERS_LOAD_BEAN = new ValueProperty(TYPE, "FindersLoadBean");
    @Type(base=IPersistenceUse.class)
    @XmlBinding(path="persistence/persistence-use")
    @Service(impl=CmpEntityEnabler.class)
    @Documentation(content="Stores an identifier of the persistence type to be used for this particular bean. Required only for EJB entity beans that use container-managed persistence services.")
    public static final ElementProperty PROP_PERSISTENCE_USE = new ElementProperty(TYPE, "PersistenceUse");

    public Value<String> getIsModifiedMethodName();

    public void setIsModifiedMethodName(String var1);

    public Value<Boolean> getDelayUpdatesUntilEndOfTx();

    public void setDelayUpdatesUntilEndOfTx(String var1);

    public void setDelayUpdatesUntilEndOfTx(Boolean var1);

    public Value<Boolean> getFindersLoadBean();

    public void setFindersLoadBean(String var1);

    public void setFindersLoadBean(Boolean var1);

    public ElementHandle<IPersistenceUse> getPersistenceUse();
}

