/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.ejbjar;

import oracle.eclipse.tools.weblogic.descriptors.ejbjar.LoadAlgorithm;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IClustering
extends Element {
    public static final ElementType TYPE = new ElementType(IClustering.class);
    @Type(base=Boolean.class)
    @XmlBinding(path="home-is-clusterable")
    @Label(standard="home is clusterable")
    @DefaultValue(text="true")
    @Documentation(content="When set to \"true\", the EJB can be deployed from multiple Oracle WebLogic Servers in a cluster.")
    public static final ValueProperty PROP_HOME_IS_CLUSTERABLE = new ValueProperty(TYPE, "HomeIsClusterable");
    @Type(base=LoadAlgorithm.class)
    @XmlBinding(path="home-load-algorithm")
    @Label(standard="home load algorithm")
    @DefaultValue(text="round-robin")
    @Enablement(expr="${ HomeIsClusterable }")
    @Documentation(content="Specifies the algorithm to use for load balancing between replicas of the EJB home in a cluster.[ul][li]round-robin: Load balancing is performed in a sequential fashion among the servers hosting the bean.[/li][li]random: Replicas of the EJB home are deployed randomly among the servers hosting the bean.[/li][li]weight-based: Replicas of the EJB home are deployed on host servers according to the servers\u2019 current workload.[/li][li]round-robin-affinity: Server affinity governs connections between external Java clients and server instances; round robin load balancing is used for connections between server instances.[/li][li]weight-based-affinity: Server affinity governs connections between external Java clients and server instances; weight-based load balancing is used for connections between server instances.[/li][li]random-affinity: Server affinity governs connections between external Java clients and server instances; random load balancing is used for connections between server instances.[/li][/ul]")
    public static final ValueProperty PROP_HOME_LOAD_ALGORITHM = new ValueProperty(TYPE, "HomeLoadAlgorithm");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @XmlBinding(path="home-call-router-class-name")
    @Label(standard="home call router")
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"weblogic.rmi.cluster.CallRouter"})
    @MustExist
    @Enablement(expr="${ HomeIsClusterable }")
    @Documentation(content="Specifies the name of a custom class to use for routing bean method calls.")
    public static final ValueProperty PROP_HOME_CALL_ROUTER_CLASS_NAME = new ValueProperty(TYPE, "HomeCallRouterClassName");
    @Type(base=Boolean.class)
    @XmlBinding(path="use-serverside-stubs")
    @Label(standard="use serverside stubs")
    @DefaultValue(text="false")
    @Documentation(content="Causes the bean home to use server-side stubs in the context of server.")
    public static final ValueProperty PROP_USE_SERVERSIDE_STUBS = new ValueProperty(TYPE, "UseServersideStubs");

    public Value<Boolean> getHomeIsClusterable();

    public void setHomeIsClusterable(String var1);

    public void setHomeIsClusterable(Boolean var1);

    public Value<LoadAlgorithm> getHomeLoadAlgorithm();

    public void setHomeLoadAlgorithm(String var1);

    public void setHomeLoadAlgorithm(LoadAlgorithm var1);

    public ReferenceValue<JavaTypeName, JavaType> getHomeCallRouterClassName();

    public void setHomeCallRouterClassName(String var1);

    public void setHomeCallRouterClassName(JavaTypeName var1);

    public Value<Boolean> getUseServersideStubs();

    public void setUseServersideStubs(String var1);

    public void setUseServersideStubs(Boolean var1);
}

