/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.deploy.internal;

import oracle.eclipse.tools.weblogic.descriptors.deploy.IVariable;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IVariableAssignment;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IWeblogicDeploymentPlan;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;

public final class VariableAssignmentValuePropertyCustomBinding
extends XmlValueBindingImpl {
    private Listener listener;

    public void init(Property property) {
        super.init(property);
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                VariableAssignmentValuePropertyCustomBinding.this.property().refresh();
            }
        };
        IVariableAssignment assignment = (IVariableAssignment)this.property().element();
        assignment.getName().attach(this.listener);
        assignment.attach(this.listener, "/VariableDefinition/Variables/Name");
        assignment.attach(this.listener, "/VariableDefinition/Variables/Value");
    }

    public String read() {
        IVariableAssignment assignment = (IVariableAssignment)this.property().element();
        String varName = assignment.getName().text();
        if (varName != null) {
            IWeblogicDeploymentPlan planModel = (IWeblogicDeploymentPlan)assignment.root();
            for (IVariable var : planModel.getVariableDefinition().getVariables()) {
                if (!varName.equals(var.getName().text())) continue;
                if (((Boolean)var.getAssignNullAttribute().content()).booleanValue()) {
                    return "NULL";
                }
                return var.getValue().text();
            }
        }
        return null;
    }

    public void write(String value) {
        IVariableAssignment assignment = (IVariableAssignment)this.property().element();
        String varName = assignment.getName().text();
        if (varName != null) {
            IWeblogicDeploymentPlan planModel = (IWeblogicDeploymentPlan)assignment.root();
            for (IVariable var : planModel.getVariableDefinition().getVariables()) {
                if (!varName.equals(var.getName().text())) continue;
                if ("NULL".equals(value)) {
                    var.setAssignNullAttribute(Boolean.TRUE);
                    var.setValue("");
                } else {
                    var.setValue(value);
                }
                return;
            }
        }
    }

    public void dispose() {
        if (this.listener != null) {
            IVariableAssignment assignment = (IVariableAssignment)this.property().element();
            if (assignment != null && !assignment.disposed()) {
                assignment.getName().detach(this.listener);
                assignment.detach(this.listener, "/VariableDefinition/Variables/Name");
                assignment.detach(this.listener, "/VariableDefinition/Variables/Value");
            }
            this.listener = null;
        }
        super.dispose();
    }
}

