/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.deploy.internal;

import oracle.eclipse.tools.weblogic.descriptors.deploy.IModuleOverride;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IWeblogicDeploymentPlan;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class ModuleTypeValidator
extends ValidationService {
    protected Status compute() {
        try {
            Value value = (Value)this.context(Value.class);
            String val = value.text();
            if (val == null) {
                return Status.createOkStatus();
            }
            IModuleOverride moduleOverride = (IModuleOverride)value.element().nearest(IModuleOverride.class);
            IWeblogicDeploymentPlan plan = (IWeblogicDeploymentPlan)moduleOverride.nearest(IWeblogicDeploymentPlan.class);
            String moduleName = moduleOverride.getModuleName().text();
            String appName = plan.getApplicationName().text();
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(appName);
            if (res instanceof IProject) {
                IProject proj = (IProject)res;
                if (FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.ear")) {
                    IVirtualComponent comp = ComponentCore.createComponent((IProject)proj);
                    if (moduleName.equals(comp.getDeployedName())) {
                        if (!val.equals("ear")) {
                            return Status.createErrorStatus((String)Resources.invalidValueMessage);
                        }
                    } else {
                        IVirtualReference[] refs;
                        IVirtualReference[] iVirtualReferenceArray = refs = comp.getReferences();
                        int n = refs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IVirtualComponent childComp;
                            IVirtualReference ref = iVirtualReferenceArray[n2];
                            String name = ref.getArchiveName();
                            if (name.equals(moduleName) && (childComp = ref.getReferencedComponent()) != null) {
                                IProject childProj = childComp.getProject();
                                if (FacetedProjectFramework.hasProjectFacet((IProject)childProj, (String)"jst.web") && !val.equals("war")) {
                                    return Status.createErrorStatus((String)Resources.invalidValueMessage);
                                }
                                if (FacetedProjectFramework.hasProjectFacet((IProject)childProj, (String)"jst.ear") && !val.equals("ear")) {
                                    return Status.createErrorStatus((String)Resources.invalidValueMessage);
                                }
                            }
                            ++n2;
                        }
                    }
                } else {
                    res = ResourcesPlugin.getWorkspace().getRoot().findMember(moduleName);
                    if (res instanceof IProject) {
                        if (val.equals("war") && !FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.web")) {
                            return Status.createErrorStatus((String)Resources.invalidValueMessage);
                        }
                        if (val.equals("ear") && !FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.ear")) {
                            return Status.createErrorStatus((String)Resources.invalidValueMessage);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {}
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String invalidValueMessage;

        static {
            Resources.initializeMessages((String)ModuleTypeValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

