/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.deploy.internal;

import java.util.TreeSet;
import oracle.eclipse.tools.weblogic.J2EEDescriptorCatalog;
import oracle.eclipse.tools.weblogic.WlsDescriptorCatalog;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IModuleOverride;
import oracle.eclipse.tools.weblogic.descriptors.deploy.IWeblogicDeploymentPlan;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;

public class ModuleDescriptorUriChangeListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        IModuleDescriptor descriptor = (IModuleDescriptor)event.property().element();
        String uri = descriptor.getUri().text();
        if (uri != null && uri.length() > 0) {
            String rootElement;
            String fileName = uri;
            if (uri.indexOf("/") > 0) {
                String[] segments = uri.split("/");
                fileName = segments[segments.length - 1];
            }
            if ((rootElement = J2EEDescriptorCatalog.getInstance().getDescriptorType(fileName)) == null) {
                rootElement = WlsDescriptorCatalog.getInstance().getDescriptorType(fileName);
            }
            descriptor.setRootElement(rootElement);
            IModuleOverride module = (IModuleOverride)descriptor.nearest(IModuleOverride.class);
            if (module == null) {
                return;
            }
            String moduleName = module.getModuleName().text();
            if (moduleName == null || moduleName.length() == 0) {
                return;
            }
            IWeblogicDeploymentPlan plan = (IWeblogicDeploymentPlan)descriptor.nearest(IWeblogicDeploymentPlan.class);
            IProject proj = (IProject)plan.adapt(IProject.class);
            if (proj == null) {
                return;
            }
            String appName = plan.getApplicationName().text();
            if (appName == null) {
                return;
            }
            TreeSet<String> names = new TreeSet<String>();
            WlsDescriptorCatalog.findDescriptorsInModule(proj, appName, moduleName, names);
            if (names.contains(uri)) {
                descriptor.setIsExternalAttribute(false);
            } else {
                descriptor.setIsExternalAttribute(true);
            }
        }
    }
}

