/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.deploy.internal;

import java.util.Set;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class ApplicationNameValuesProvider
extends PossibleValuesService {
    public String getInvalidValueMessage(String invalidValue) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        String msg = Resources.invalidValueMessage;
        IFile workspaceFile = (IFile)((Element)this.context(Element.class)).adapt(IFile.class);
        if (workspaceFile == null) {
            msg = Resources.invalidValueWarning;
        }
        Thread.currentThread().setContextClassLoader(cl);
        return NLS.bind((String)msg, (Object)invalidValue);
    }

    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        return Status.Severity.WARNING;
    }

    protected void fillPossibleValues(Set<String> values) {
        IFile workspaceFile = (IFile)((Element)this.context(Element.class)).adapt(IFile.class);
        if (workspaceFile == null) {
            this.addAllJ2EEProjects(values);
            return;
        }
        IProject proj = workspaceFile.getProject();
        try {
            if (FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.ear") || FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.web") || FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.ejb")) {
                IVirtualComponent comp = ComponentCore.createComponent((IProject)proj);
                String ext = FacetUtil.getResourceExtension(proj);
                values.add(String.valueOf(comp.getDeployedName()) + ext);
            } else {
                this.addAllJ2EEProjects(values);
            }
        }
        catch (CoreException coreException) {}
    }

    private void addAllJ2EEProjects(Set<String> set) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            try {
                if (FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.ear") || FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.web") || FacetedProjectFramework.hasProjectFacet((IProject)proj, (String)"jst.ejb")) {
                    IVirtualComponent comp = ComponentCore.createComponent((IProject)proj);
                    String ext = FacetUtil.getResourceExtension(proj);
                    set.add(String.valueOf(comp.getDeployedName()) + ext);
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
    }

    static final class Resources
    extends NLS {
        public static String invalidValueMessage;
        public static String invalidValueWarning;

        static {
            Resources.initializeMessages((String)ApplicationNameValuesProvider.class.getName(), Resources.class);
        }

        Resources() {
        }
    }
}

