/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.common.internal;

import oracle.eclipse.tools.weblogic.descriptors.common.IWebServiceOperationConfig;
import oracle.eclipse.tools.weblogic.descriptors.common.IWebServicePortConfig;
import oracle.eclipse.tools.weblogic.descriptors.common.IWebServicesAtomicTransactionConfig;
import oracle.eclipse.tools.weblogic.descriptors.common.WebServicesAtomicTransactionVersion;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public final class WebServicesAtomicTransactionConfigVersionValidationService
extends ValidationService {
    @Text(value="Atomic transaction version must match across all operations in a given web service port")
    private static LocalizableText versionsMustMatch;
    private Listener listener;

    static {
        LocalizableText.init(WebServicesAtomicTransactionConfigVersionValidationService.class);
    }

    protected void initValidationService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                WebServicesAtomicTransactionConfigVersionValidationService.this.refresh();
            }
        };
        Element element = (Element)this.context(Element.class);
        element.attach(this.listener, "../../AtomicTransactionConfig/TransactionVersion");
        element.attach(this.listener, "../../Operations/AtomicTransactionConfig/TransactionVersion");
    }

    protected Status compute() {
        Value value = (Value)this.context(Value.class);
        WebServicesAtomicTransactionVersion version = (WebServicesAtomicTransactionVersion)((Object)value.content());
        IWebServicePortConfig port = (IWebServicePortConfig)value.element().nearest(IWebServicePortConfig.class);
        IWebServicesAtomicTransactionConfig portLevelWsAtConfig = (IWebServicesAtomicTransactionConfig)port.getAtomicTransactionConfig().content();
        boolean problem = false;
        if (portLevelWsAtConfig != null && ((Boolean)portLevelWsAtConfig.isEnabled().content()).booleanValue() && !WebServicesAtomicTransactionConfigVersionValidationService.equal((WebServicesAtomicTransactionVersion)((Object)portLevelWsAtConfig.getTransactionVersion().content()), version)) {
            problem = true;
        }
        if (!problem) {
            for (IWebServiceOperationConfig op : port.getOperations()) {
                IWebServicesAtomicTransactionConfig opLevelWsAtConfig = (IWebServicesAtomicTransactionConfig)op.getAtomicTransactionConfig().content();
                if (opLevelWsAtConfig == null || !((Boolean)opLevelWsAtConfig.isEnabled().content()).booleanValue() || WebServicesAtomicTransactionConfigVersionValidationService.equal((WebServicesAtomicTransactionVersion)((Object)opLevelWsAtConfig.getTransactionVersion().content()), version)) continue;
                problem = true;
            }
        }
        if (problem) {
            return Status.createErrorStatus((String)versionsMustMatch.text());
        }
        return Status.createOkStatus();
    }

    private static boolean equal(WebServicesAtomicTransactionVersion x, WebServicesAtomicTransactionVersion y) {
        WebServicesAtomicTransactionVersion b;
        WebServicesAtomicTransactionVersion a = x == WebServicesAtomicTransactionVersion.DEFAULT ? WebServicesAtomicTransactionVersion.WSAT10 : x;
        WebServicesAtomicTransactionVersion webServicesAtomicTransactionVersion = b = y == WebServicesAtomicTransactionVersion.DEFAULT ? WebServicesAtomicTransactionVersion.WSAT10 : y;
        return a == b;
    }

    public void dispose() {
        if (this.listener != null) {
            Element element = (Element)this.context(Element.class);
            element.detach(this.listener, "../../AtomicTransactionConfig/TransactionVersion");
            element.detach(this.listener, "../../Operations/AtomicTransactionConfig/TransactionVersion");
            this.listener = null;
        }
        super.dispose();
    }
}

