/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.common.internal;

import oracle.eclipse.tools.weblogic.WebLogicDescriptorInfo;
import oracle.eclipse.tools.weblogic.WebLogicDescriptorType;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicDescriptor;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.w3c.dom.Document;

public final class WebLogicServerVersionListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        WebLogicDescriptorType descriptorType;
        WebLogicDescriptorInfo dinfo;
        IWebLogicDescriptor descriptor = (IWebLogicDescriptor)event.property().element().nearest(IWebLogicDescriptor.class);
        WebLogicServerVersion version = WebLogicServerVersion.convert((Version)descriptor.getServerVersion().content());
        if (version != null && (dinfo = (descriptorType = WebLogicDescriptorType.getDescriptorType(descriptor)).getDescriptorInfo(version)) != null) {
            XmlElement element = ((XmlResource)descriptor.adapt(XmlResource.class)).getXmlElement(true);
            String currentNamespace = element.getNamespace();
            String expectedNamespace = dinfo.getNamespace();
            String expectedSchemaLocation = dinfo.getSchemaLocation();
            boolean namespaceChangeNeeded = false;
            if (currentNamespace.equals(expectedNamespace)) {
                String currentSchemaLocation = element.getSchemaLocation();
                if (currentSchemaLocation == null || !currentSchemaLocation.equals(expectedSchemaLocation)) {
                    namespaceChangeNeeded = true;
                }
            } else {
                namespaceChangeNeeded = true;
            }
            if (namespaceChangeNeeded) {
                Document document = ((XmlResource)descriptor.adapt(XmlResource.class)).getXmlElement().getDomNode().getOwnerDocument();
                XmlUtil.changeNamespace((Document)document, (String)currentNamespace, (String)expectedNamespace, (String)expectedSchemaLocation);
            }
        }
    }
}

