/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.common.internal;

import java.util.Collections;
import oracle.eclipse.tools.common.util.ObjectUtil;
import oracle.eclipse.tools.weblogic.WebLogicDescriptorInfo;
import oracle.eclipse.tools.weblogic.WebLogicDescriptorType;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.descriptors.common.internal.WebLogicServerVersionDefaultValueService;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.StandardRootElementController;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.w3c.dom.Element;

public final class WebLogicDescriptorRootElementController
extends StandardRootElementController {
    private WebLogicDescriptorType type;

    public void init(XmlResource resource) {
        super.init(resource);
        this.type = WebLogicDescriptorType.getDescriptorType(resource.element().type());
    }

    public void createRootElement() {
        WebLogicServerVersion wlsVersion = WebLogicServerVersionDefaultValueService.getDefaultServerVersion((IProject)this.resource().adapt(IProject.class));
        WebLogicDescriptorInfo dinfo = this.type.getDescriptorInfo(wlsVersion);
        if (dinfo == null) {
            dinfo = this.type.getDescriptorInfo(WebLogicServerVersion.getNewestVersion());
        }
        StandardRootElementController.RootElementInfo rinfo = new StandardRootElementController.RootElementInfo(dinfo.getNamespace(), dinfo.getDefaultNamespacePrefix(), dinfo.getRootElementName(), Collections.singletonMap(dinfo.getNamespace(), dinfo.getSchemaLocation()));
        this.createRootElement(((RootXmlResource)this.resource().adapt(RootXmlResource.class)).getDomDocument(), rinfo);
    }

    public boolean checkRootElement() {
        Element root = ((RootXmlResource)this.resource().adapt(RootXmlResource.class)).getDomDocument().getDocumentElement();
        String localName = root.getLocalName();
        String namespace = root.getNamespaceURI();
        for (WebLogicDescriptorInfo dinfo : this.type.getDescriptorInfos()) {
            if (!ObjectUtil.equal((Object)localName, (Object)dinfo.getRootElementName()) || !ObjectUtil.equal((Object)namespace, (Object)dinfo.getNamespace())) continue;
            return true;
        }
        return false;
    }
}

