/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.common.internal;

import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public final class LogRotationStartTimeValidationService
extends ValidationService {
    @Text(value="\"{0}\" is not a valid log rotation start time (required format is h:mm where h is 1-24 and mm is 0-59)")
    private static LocalizableText invalidFormatMessage;

    static {
        LocalizableText.init(LogRotationStartTimeValidationService.class);
    }

    protected Status compute() {
        String str = ((Value)this.context(Value.class)).text(true);
        boolean valid = false;
        if (str != null) {
            int colon = str.indexOf(58);
            if (colon != -1 && colon < str.length() - 1) {
                String hoursStr = str.substring(0, colon);
                String minutesStr = str.substring(colon + 1);
                try {
                    int hours = Integer.parseInt(hoursStr);
                    int minutes = Integer.parseInt(minutesStr);
                    if (hours >= 1 && hours <= 24 && minutes >= 0 && minutes <= 59) {
                        valid = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            valid = true;
        }
        if (valid) {
            return Status.createOkStatus();
        }
        return Status.createErrorStatus((String)invalidFormatMessage.format(new Object[]{str}));
    }
}

