/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.common;

import oracle.eclipse.tools.weblogic.descriptors.common.WebServicesAtomicTransactionFlowType;
import oracle.eclipse.tools.weblogic.descriptors.common.WebServicesAtomicTransactionVersion;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IWebServicesAtomicTransactionConfig
extends Element {
    public static final ElementType TYPE = new ElementType(IWebServicesAtomicTransactionConfig.class);
    @Type(base=Boolean.class)
    @XmlBinding(path="enabled")
    @Label(standard="enable atomic transactions")
    @DefaultValue(text="true")
    @Documentation(content="This property is part of configuration of Web Services Atomic Transaction (WS-AT) subsystem on the server side (transactional participant) and on the client side (transactional initiator).[pbr/]Specifies whether WS-AT should be enabled. Defaults to true.")
    public static final ValueProperty PROP_ENABLED = new ValueProperty(TYPE, "Enabled");
    @Type(base=WebServicesAtomicTransactionFlowType.class)
    @XmlBinding(path="flow-type")
    @Label(standard="flow type")
    @Enablement(expr="${ Enabled }")
    @DefaultValue(text="SUPPORTS")
    @Documentation(content="This property is part of configuration of Web Services Atomic Transaction (WS-AT) subsystem on the server side (transactional participant) and on the client side (transactional initiator).[pbr/]Specifies the transaction flow type that should be supported.")
    public static final ValueProperty PROP_FLOW_TYPE = new ValueProperty(TYPE, "FlowType");
    @Type(base=WebServicesAtomicTransactionVersion.class)
    @XmlBinding(path="version")
    @Label(standard="transaction version")
    @DefaultValue(text="DEFAULT")
    @Enablement(expr="${ Enabled }")
    @Documentation(content="This property is part of configuration of Web Services Atomic Transaction (WS-AT) subsystem on the server side (transactional participant) and on the client side (transactional initiator).[pbr/]Specifies the version of WS-AT that should be supported. Defaults to DEFAULT, which specifies WS-AT 1.0 on the client side and WS-AT 1.0, WS-AT 1.1 and WS-AT 1.2 on the server side.")
    public static final ValueProperty PROP_TRANSACTION_VERSION = new ValueProperty(TYPE, "TransactionVersion");

    public Value<Boolean> isEnabled();

    public void setEnabled(String var1);

    public void setEnabled(Boolean var1);

    public Value<WebServicesAtomicTransactionFlowType> getFlowType();

    public void setFlowType(String var1);

    public void setFlowType(WebServicesAtomicTransactionFlowType var1);

    public Value<WebServicesAtomicTransactionVersion> getTransactionVersion();

    public void setTransactionVersion(String var1);

    public void setTransactionVersion(WebServicesAtomicTransactionVersion var1);
}

