/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.common;

import oracle.eclipse.tools.weblogic.descriptors.common.LogFileRotationPolicy;
import oracle.eclipse.tools.weblogic.descriptors.common.LoggingPolicy;
import oracle.eclipse.tools.weblogic.descriptors.common.internal.LogRotationStartTimeValidationService;
import oracle.eclipse.tools.weblogic.descriptors.common.internal.LoggingPolicyBinding;
import oracle.eclipse.tools.weblogic.descriptors.common.internal.LoggingRotationPolicyListener;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Listeners;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlValueBinding;

public interface ILoggingConfiguration
extends Element {
    public static final ElementType TYPE = new ElementType(ILoggingConfiguration.class);
    @Type(base=LoggingPolicy.class)
    @Label(standard="policy", full="logging policy")
    @DefaultValue(text="WRITE_TO_SYSTEM_LOG")
    @CustomXmlValueBinding(impl=LoggingPolicyBinding.class)
    @Documentation(content="Controls logging from managed connections. By default, log events are sent to the system log, but you can choose to send log events to a separate file or even disable logging completely.")
    public static final ValueProperty PROP_POLICY = new ValueProperty(TYPE, "Policy");
    @Label(standard="log file name")
    @Required
    @Enablement(expr="${ Policy == 'WRITE_TO_SEPARATE_FILE' }")
    @XmlValueBinding(path="log-filename", removeNodeOnSetIfNull=false)
    @Documentation(content="Specifies the path of the log file. The path should include the file name. It can be either absolute or relative to the $DOMAIN_DIR/servers/$SERVER_NAME/logs directory.")
    public static final ValueProperty PROP_LOG_FILE_NAME = new ValueProperty(TYPE, "LogFileName");
    @Label(standard="date format")
    @DefaultValue(text="MMM d, yyyy h:mm:ss a z")
    @Enablement(expr="${ Policy == 'WRITE_TO_SEPARATE_FILE' }")
    @XmlBinding(path="date-format-pattern")
    @Documentation(content="Specify the date format that should be used when writing log events. The format syntax is specified by Java's SimpleDateFormat.", topics={@Documentation.Topic(label="SimpleDateFormat", url="http://java.sun.com/javase/6/docs/api/java/text/SimpleDateFormat.html")})
    public static final ValueProperty PROP_DATE_FORMAT = new ValueProperty(TYPE, "DateFormat");
    @Type(base=LogFileRotationPolicy.class)
    @Label(standard="policy", full="log file rotation policy")
    @DefaultValue(text="BYSIZE")
    @Enablement(expr="${ Policy == 'WRITE_TO_SEPARATE_FILE' }")
    @XmlBinding(path="rotation-type")
    @Listeners(value={LoggingRotationPolicyListener.class})
    @Documentation(content="Sets the log file rotation policy. Valid values are \"By Size\", \"By Time\" and \"No Rotation\":[pbr/]* By Size - When the log file reaches the size that is specified by file size limit, the server will copy the current log file to the rotation directory as FileName.n and clear the main log file.[pbr/]* By Time - At each specified time interval, the server will copy the current log file to the rotation directory as FileName.n and clear the main log file.[pbr/]* No Rotation - Messages accumulate in a single file. You must erase the contents of the file when the size is unwieldy.")
    public static final ValueProperty PROP_LOG_FILE_ROTATION_POLICY = new ValueProperty(TYPE, "LogFileRotationPolicy");
    @Type(base=Integer.class)
    @Label(standard="file size limit (kilobytes)")
    @DefaultValue(text="500")
    @NumericRange(min="1")
    @Enablement(expr="${ Policy == 'WRITE_TO_SEPARATE_FILE' && LogFileRotationPolicy == 'BYSIZE' }")
    @XmlBinding(path="file-size-limit")
    @Documentation(content="The size of log file (in kilobytes) that triggers the server to move log messages to a separate file. The default is 500 kilobytes when the server is in dev mode and 5000 kilobytes when the server is in production mode. [pbr/]After the log file reaches the specified minimum size, the next time the server checks the file size, it will rename the current log file as FileName.n and create a new one to store subsequent messages.")
    public static final ValueProperty PROP_FILE_SIZE_LIMIT = new ValueProperty(TYPE, "FileSizeLimit");
    @Label(standard="rotation directory")
    @Enablement(expr="${ Policy == 'WRITE_TO_SEPARATE_FILE' && ( LogFileRotationPolicy == 'BYSIZE' || LogFileRotationPolicy == 'BYTIME' ) }")
    @XmlBinding(path="log-file-rotation-dir")
    @Documentation(content="Specifies the directory path where the rotated log files will be stored. The path can be either absolute or relative to the $DOMAIN_DIR/servers/$SERVER_NAME/logs directory. If the rotation directory is not specified, the rotation will happen in the same directory where the primary log file is located.")
    public static final ValueProperty PROP_ROTATION_DIRECTORY = new ValueProperty(TYPE, "RotationDirectory");
    @Type(base=Boolean.class)
    @Label(standard="rotate log file on server startup")
    @DefaultValue(text="true")
    @Enablement(expr="${ Policy == 'WRITE_TO_SEPARATE_FILE' && ( LogFileRotationPolicy == 'BYSIZE' || LogFileRotationPolicy == 'BYTIME' ) }")
    @XmlBinding(path="rotate-log-on-startup")
    @Documentation(content="Specifies whether a server rotates its log file during its startup cycle.")
    public static final ValueProperty PROP_ROTATE_ON_SERVER_STARTUP_ENABLED = new ValueProperty(TYPE, "RotateOnServerStartupEnabled");
    @Type(base=Boolean.class)
    @Label(standard="limit the number of old log files")
    @DefaultValue(text="false")
    @Enablement(expr="${ Policy == 'WRITE_TO_SEPARATE_FILE' && ( LogFileRotationPolicy == 'BYSIZE' || LogFileRotationPolicy == 'BYTIME' ) }")
    @XmlBinding(path="number-of-files-limited")
    @Documentation(content="Specifies whether the number of files that this server instance creates to store old messages should be limited. After the server reaches this limit, it overwrites the oldest file. If you do not enable this option, the server creates new files indefinitely and you must clean up these files as you require.")
    public static final ValueProperty PROP_LOG_FILE_COUNT_LIMIT_ENABLED = new ValueProperty(TYPE, "LogFileCountLimitEnabled");
    @Type(base=Integer.class)
    @Enablement(expr="${ LogFileCountLimitEnabled }")
    @Label(standard="log file limit")
    @DefaultValue(text="7")
    @NumericRange(min="1")
    @XmlBinding(path="file-count")
    @Documentation(content="The maximum number of log files that the server creates when it rotates the log. This number does not include the file that the server uses to store current messages.")
    public static final ValueProperty PROP_LOG_FILE_COUNT_LIMIT = new ValueProperty(TYPE, "LogFileCountLimit");
    @Label(standard="rotation start time")
    @Service(impl=LogRotationStartTimeValidationService.class)
    @Enablement(expr="${ Policy == 'WRITE_TO_SEPARATE_FILE' && LogFileRotationPolicy == 'BYTIME' }")
    @XmlBinding(path="rotation-time")
    @Documentation(content="The start time for a time-based rotation sequence of the log file, in the format h:mm, where h is 1-24. At the specified time, the server renames the current log file. Thereafter, the server renames the log file at an interval that you specify.[pbr/]If the specified time has already past, then the server starts its file rotation immediately.[pbr/]By default, the rotation cycle begins immediately.")
    public static final ValueProperty PROP_ROTATION_START_TIME = new ValueProperty(TYPE, "RotationStartTime");
    @Type(base=Integer.class)
    @Label(standard="rotation interval (hrs)")
    @DefaultValue(text="24")
    @NumericRange(min="1")
    @Enablement(expr="${ Policy == 'WRITE_TO_SEPARATE_FILE' && LogFileRotationPolicy == 'BYTIME' }")
    @XmlBinding(path="file-time-span")
    @Documentation(content="The interval (in hours) at which the server saves old log messages to another file.")
    public static final ValueProperty PROP_ROTATION_INTERVAL = new ValueProperty(TYPE, "RotationInterval");

    public Value<LoggingPolicy> getPolicy();

    public void setPolicy(String var1);

    public void setPolicy(LoggingPolicy var1);

    public Value<String> getLogFileName();

    public void setLogFileName(String var1);

    public Value<String> getDateFormat();

    public void setDateFormat(String var1);

    public Value<LogFileRotationPolicy> getLogFileRotationPolicy();

    public void setLogFileRotationPolicy(String var1);

    public void setLogFileRotationPolicy(LogFileRotationPolicy var1);

    public Value<Integer> getFileSizeLimit();

    public void setFileSizeLimit(String var1);

    public void setFileSizeLimit(Integer var1);

    public Value<String> getRotationDirectory();

    public void setRotationDirectory(String var1);

    public Value<Boolean> isRotateOnServerStartupEnabled();

    public void setRotateOnServerStartupEnabled(String var1);

    public void setRotateOnServerStartupEnabled(Boolean var1);

    public Value<Boolean> isLogFileCountLimitEnabled();

    public void setLogFileCountLimitEnabled(String var1);

    public void setLogFileCountLimitEnabled(Boolean var1);

    public Value<Integer> getLogFileCountLimit();

    public void setLogFileCountLimit(String var1);

    public void setLogFileCountLimit(Integer var1);

    public Value<String> getRotationStartTime();

    public void setRotationStartTime(String var1);

    public Value<Integer> getRotationInterval();

    public void setRotationInterval(String var1);

    public void setRotationInterval(Integer var1);
}

