/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.app.internal;

import oracle.eclipse.tools.weblogic.descriptors.EntityCacheSizeUnits;
import oracle.eclipse.tools.weblogic.descriptors.IEntityCache;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;

public final class EntityCacheMaxCacheSizeUnitsBinding
extends XmlValueBindingImpl {
    private static final XmlPath PATH_MAX_BEANS_IN_CACHE = new XmlPath("max-beans-in-cache");
    private static final XmlPath PATH_MAX_CACHE_SIZE = new XmlPath("max-cache-size");
    private static final XmlPath PATH_MEGABYTES = new XmlPath("max-cache-size/megabytes");
    private static final XmlPath PATH_BYTES = new XmlPath("max-cache-size/bytes");

    public String read() {
        XmlElement el = this.xml(false);
        String val = null;
        if (el != null) {
            if (el.getChildNode(PATH_MAX_BEANS_IN_CACHE, false) != null) {
                val = EntityCacheSizeUnits.BEANS.name();
            } else if (el.getChildNode(PATH_BYTES, false) != null) {
                val = EntityCacheSizeUnits.BYTES.name();
            } else if (el.getChildNode(PATH_MEGABYTES, false) != null) {
                val = EntityCacheSizeUnits.MEGABYTES.name();
            }
        }
        return val;
    }

    public void write(String value) {
        IEntityCache entityCacheElement = (IEntityCache)this.property().element();
        XmlElement el = this.xml(true);
        String maxCacheSize = entityCacheElement.getMaxCacheSize().text(true);
        if (EntityCacheSizeUnits.BEANS.name().equals(value)) {
            el.removeChildNode(PATH_MAX_CACHE_SIZE);
            el.setChildNodeText(PATH_MAX_BEANS_IN_CACHE, maxCacheSize, false);
        } else if (EntityCacheSizeUnits.BYTES.name().equals(value)) {
            el.removeChildNode(PATH_MAX_BEANS_IN_CACHE);
            el.removeChildNode(PATH_MEGABYTES);
            el.setChildNodeText(PATH_BYTES, maxCacheSize, false);
        } else if (EntityCacheSizeUnits.MEGABYTES.name().equals(value)) {
            el.removeChildNode(PATH_MAX_BEANS_IN_CACHE);
            el.removeChildNode(PATH_BYTES);
            el.setChildNodeText(PATH_MEGABYTES, maxCacheSize, false);
        } else {
            el.removeChildNode(PATH_MAX_CACHE_SIZE);
            el.removeChildNode(PATH_MAX_BEANS_IN_CACHE);
        }
    }

    public XmlNode getXmlNode() {
        XmlElement el = this.xml(false);
        XmlNode node = null;
        if (el != null && (node = el.getChildNode(PATH_MAX_BEANS_IN_CACHE, false)) == null && (node = el.getChildNode(PATH_BYTES, false)) == null) {
            node = el.getChildNode(PATH_MEGABYTES, false);
        }
        return node;
    }
}

