/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.ICapacityConstraint;
import oracle.eclipse.tools.weblogic.descriptors.ICapacityConstraintReference;
import oracle.eclipse.tools.weblogic.descriptors.IContextRequestClass;
import oracle.eclipse.tools.weblogic.descriptors.IFairShareRequestClass;
import oracle.eclipse.tools.weblogic.descriptors.IMaximumThreadsConstraint;
import oracle.eclipse.tools.weblogic.descriptors.IMaximumThreadsConstraintReference;
import oracle.eclipse.tools.weblogic.descriptors.IMinimumThreadsConstraint;
import oracle.eclipse.tools.weblogic.descriptors.IMinimumThreadsConstraintReference;
import oracle.eclipse.tools.weblogic.descriptors.IRequestClassReference;
import oracle.eclipse.tools.weblogic.descriptors.IResponseTimeRequestClass;
import oracle.eclipse.tools.weblogic.descriptors.ISchedulingGuideline;
import oracle.eclipse.tools.weblogic.descriptors.StuckThreadHandlingPolicy;
import oracle.eclipse.tools.weblogic.descriptors.internal.SchedulingGuidelinesValidator;
import oracle.eclipse.tools.weblogic.descriptors.internal.StuckThreadHandlingPolicyBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.FixedOrderList;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NoDuplicates;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

@Label(standard="work manager")
public interface IWorkManagerDefinition
extends Element {
    public static final ElementType TYPE = new ElementType(IWorkManagerDefinition.class);
    @Label(standard="name")
    @Required
    @NoDuplicates
    @XmlBinding(path="name")
    @Documentation(content="Specifies the name of the work manager.")
    public static final ValueProperty PROP_NAME = new ValueProperty(TYPE, "Name");
    @Type(base=StuckThreadHandlingPolicy.class)
    @Label(standard="policy", full="stuck thread handling policy")
    @DefaultValue(text="NONE")
    @CustomXmlValueBinding(impl=StuckThreadHandlingPolicyBinding.class)
    @Documentation(content="In response to stuck threads, you can specify whether you want to shut down the work manager, to move the application into admin mode, or to mark the server instance as failed.")
    public static final ValueProperty PROP_STUCK_THREAD_HANDLING_POLICY = new ValueProperty(TYPE, "StuckThreadHandlingPolicy");
    @Type(base=Integer.class)
    @Label(standard="max stuck thread time (secs)")
    @Enablement(expr="${ StuckThreadHandlingPolicy == 'SHUTDOWN_TRIGGER' }")
    @NumericRange(min="1")
    @XmlBinding(path="work-manager-shutdown-trigger/max-stuck-thread-time")
    @Documentation(content="In response to stuck threads, you can specify whether you want to shut down the work manager, to move the application into admin mode, or to mark the server instance as failed.")
    public static final ValueProperty PROP_MAX_STUCK_THREAD_TIME = new ValueProperty(TYPE, "MaxStuckThreadTime");
    @Type(base=Integer.class)
    @Label(standard="stuck thread count")
    @Enablement(expr="${ StuckThreadHandlingPolicy == 'SHUTDOWN_TRIGGER' }")
    @Required
    @NumericRange(min="1")
    @XmlBinding(path="work-manager-shutdown-trigger/stuck-thread-count")
    @Documentation(content="In response to stuck threads, you can specify whether you want to shut down the work manager, to move the application into admin mode, or to mark the server instance as failed.", topics={@Documentation.Topic(label="Request Classes", url="oracle.eclipse.tools.weblogic.doc/context/html/RequestClasses.html"), @Documentation.Topic(label="Constraints", url="oracle.eclipse.tools.weblogic.doc/context/html/Constraints.html")})
    public static final ValueProperty PROP_STUCK_THREAD_COUNT = new ValueProperty(TYPE, "StuckThreadCount");
    @Type(base=ISchedulingGuideline.class, possible={IResponseTimeRequestClass.class, IFairShareRequestClass.class, IContextRequestClass.class, IRequestClassReference.class, IMinimumThreadsConstraint.class, IMinimumThreadsConstraintReference.class, IMaximumThreadsConstraint.class, IMaximumThreadsConstraintReference.class, ICapacityConstraint.class, ICapacityConstraintReference.class})
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="response-time-request-class", type=IResponseTimeRequestClass.class), @XmlListBinding.Mapping(element="fair-share-request-class", type=IFairShareRequestClass.class), @XmlListBinding.Mapping(element="context-request-class", type=IContextRequestClass.class), @XmlListBinding.Mapping(element="request-class-name", type=IRequestClassReference.class), @XmlListBinding.Mapping(element="min-threads-constraint", type=IMinimumThreadsConstraint.class), @XmlListBinding.Mapping(element="min-threads-constraint-name", type=IMinimumThreadsConstraintReference.class), @XmlListBinding.Mapping(element="max-threads-constraint", type=IMaximumThreadsConstraint.class), @XmlListBinding.Mapping(element="max-threads-constraint-name", type=IMaximumThreadsConstraintReference.class), @XmlListBinding.Mapping(element="capacity", type=ICapacityConstraint.class), @XmlListBinding.Mapping(element="capacity-name", type=ICapacityConstraintReference.class)})
    @Label(standard="scheduling guidelines")
    @FixedOrderList
    @Service(impl=SchedulingGuidelinesValidator.class)
    @Documentation(content="Various scheduling guidelines can be used to guide WebLogic Server in allocating threads to requests. There are two categories of scheduling guidelines: request classes and constraints.[pbr/]Request classes help ensure that high priority work is scheduled before less important work, even if the high priority work is submitted after the low priority work. There are multiple types of request classes, each of which expresses this scheduling guideline in different terms. A work manager may specify only one request class.[pbr/]Constraints define minimum and maximum numbers of threads allocated to execute requests and the total number of requests that can be queued or executing before WebLogic Server begins rejecting requests.")
    public static final ListProperty PROP_SCHEDULING_GUIDELINES = new ListProperty(TYPE, "SchedulingGuidelines");

    public Value<String> getName();

    public void setName(String var1);

    public Value<StuckThreadHandlingPolicy> getStuckThreadHandlingPolicy();

    public void setStuckThreadHandlingPolicy(String var1);

    public void setStuckThreadHandlingPolicy(StuckThreadHandlingPolicy var1);

    public Value<Integer> getMaxStuckThreadTime();

    public void setMaxStuckThreadTime(String var1);

    public void setMaxStuckThreadTime(Integer var1);

    public Value<Integer> getStuckThreadCount();

    public void setStuckThreadCount(String var1);

    public void setStuckThreadCount(Integer var1);

    public ElementList<ISchedulingGuideline> getSchedulingGuidelines();
}

