/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.IVirtualDirectoryMappingUrlPattern;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.annotations.AbsolutePath;
import org.eclipse.sapphire.modeling.annotations.CountConstraint;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

@Label(standard="virtual directory mapping")
public interface IVirtualDirectoryMapping
extends Element {
    public static final ElementType TYPE = new ElementType(IVirtualDirectoryMapping.class);
    @Type(base=Path.class)
    @XmlBinding(path="local-path")
    @Label(standard="local path")
    @Required
    @ValidFileSystemResourceType(value=FileSystemResourceType.FOLDER)
    @AbsolutePath
    @MustExist
    @Documentation(content="Used to specify document roots other than the default document root of the Web application for certain kinds of requests, such as image requests. All images for a set of Web applications can be stored in a single location, and need not be copied to the document root of each Web application that uses them. For an incoming request, if a virtual directory has been specified, servlet container will search for the requested resource first in the virtual directory, and then in the Web application\u2019s original document root. This defines the precedence if the same document exists in both places.")
    public static final ValueProperty PROP_LOCAL_PATH = new ValueProperty(TYPE, "LocalPath");
    @Type(base=IVirtualDirectoryMappingUrlPattern.class)
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="url-pattern", type=IVirtualDirectoryMappingUrlPattern.class)})
    @Label(standard="URL patterns")
    @CountConstraint(min=1)
    @Documentation(content="Used to specify document roots other than the default document root of the Web application for certain kinds of requests, such as image requests. All images for a set of Web applications can be stored in a single location, and need not be copied to the document root of each Web application that uses them. For an incoming request, if a virtual directory has been specified, servlet container will search for the requested resource first in the virtual directory, and then in the Web application\u2019s original document root. This defines the precedence if the same document exists in both places.")
    public static final ListProperty PROP_URL_PATTERNS = new ListProperty(TYPE, "UrlPatterns");

    public Value<Path> getLocalPath();

    public void setLocalPath(String var1);

    public void setLocalPath(Path var1);

    public ElementList<IVirtualDirectoryMappingUrlPattern> getUrlPatterns();
}

