/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.PersistentStoreType;
import oracle.eclipse.tools.weblogic.descriptors.internal.PersistentStoreTypeValidator;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.VersionCompatibility;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface ISessionDescriptorSection
extends Element {
    public static final ElementType TYPE = new ElementType(ISessionDescriptorSection.class);
    @Type(base=Integer.class)
    @XmlBinding(path="cache-size")
    @Enablement(expr="${ PersistentStoreType == 'file' || PersistentStoreType == 'jdbc' || PersistentStoreType == 'async_jdbc' }")
    @Label(standard="cache size")
    @DefaultValue(text="1028")
    @NumericRange(min="1")
    @Documentation(content="Sets the cache size for JDBC and file-persistent sessions.")
    public static final ValueProperty PROP_CACHE_SIZE = new ValueProperty(TYPE, "CacheSize");
    @XmlBinding(path="cookie-comment")
    @Label(standard="cookie comment")
    @Documentation(content="Specifies the comment that identifies the session tracking cookie in the cookie file.")
    public static final ValueProperty PROP_COOKIE_COMMENT = new ValueProperty(TYPE, "CookieComment");
    @XmlBinding(path="cookie-domain")
    @Label(standard="cookie trigger domain")
    @Documentation(content="Specifies the domain for which the cookie is valid. For example, setting \"cookie-domain\" to .mydomain.com returns cookies to any server in the *.mydomain.com domain.[pbr/]The domain name must have at least two components. Setting a name to *.com or *.net is not valid.[pbr/]If not set, this attribute defaults to the server that issued the cookie.[pbr/]For more information, see Cookie.setDomain() method in the Servlet specification from Sun Microsystems.")
    public static final ValueProperty PROP_COOKIE_DOMAIN = new ValueProperty(TYPE, "CookieDomain");
    @NamedValues(arbitraryValueLabel="cookie lifespan", defaultArbitraryValue="3600", namedValues={@NamedValues.NamedValue(value="-1", label="cookies never expire")})
    @Type(base=Integer.class)
    @Label(standard="lifespan of cookies (in seconds)")
    @DefaultValue(text="-1")
    @NumericRange(min="-1")
    @XmlBinding(path="cookie-max-age-secs")
    @Documentation(content="Sets the life span of the session cookie, in seconds, after which it expires on the client.[pbr/]The default value is -1 (unlimited).[pbr/]For more information about cookies, see Using Sessions and Session Persistence.")
    public static final ValueProperty PROP_COOKIE_MAX_AGE_SECS = new ValueProperty(TYPE, "CookieMaxAgeSecs");
    @XmlBinding(path="cookie-name")
    @Label(standard="cookie name")
    @DefaultValue(text="JSESSIONID")
    @Documentation(content="Defines the session tracking cookie name. [pbr/]The default value is \"JSESSIONID\". You may set this to a more specific name for your application.")
    public static final ValueProperty PROP_COOKIE_NAME = new ValueProperty(TYPE, "CookieName");
    @XmlBinding(path="cookie-path")
    @Label(standard="cookie trigger path")
    @DefaultValue(text="/")
    @Documentation(content="Defines the session tracking cookie path.[pbr/]If not set, this attribute defaults to \" / \" (slash), where the browser sends cookies to all URLs served by Oracle WebLogic Server. You may set the path to a narrower mapping in order to limit the request URLs to which the browser sends cookies.")
    public static final ValueProperty PROP_COOKIE_PATH = new ValueProperty(TYPE, "CookiePath");
    @Type(base=Boolean.class)
    @XmlBinding(path="cookie-secure")
    @Label(standard="send cookies over HTTPS only")
    @DefaultValue(text="false")
    @Documentation(content="Tells the browser to only send the cookie back over an HTTPS connection. This ensures that the cookie ID is secure and should only be used on Web sites that use HTTPS. Session Cookies over HTTP no longer work if this feature is enabled.[pbr/]You should disable the \"url-rewriting-enabled\" element if you intend to use this feature.")
    public static final ValueProperty PROP_COOKIE_SECURE = new ValueProperty(TYPE, "CookieSecure");
    @Type(base=Boolean.class)
    @XmlBinding(path="cookies-enabled")
    @Label(standard="enable cookies")
    @DefaultValue(text="true")
    @Documentation(content="Use of session cookies is enabled by default and is recommended, but you can disable session cookies by setting this property to \"false\". You might turn this option off for testing.")
    public static final ValueProperty PROP_COOKIES_ENABLED = new ValueProperty(TYPE, "CookiesEnabled");
    @Type(base=Boolean.class)
    @Label(standard="mark session cookie as HttpOnly")
    @VersionCompatibility(value="[9.2.4-10.0),[10.0.2-10.3),[10.3.1")
    @DefaultValue(text="true")
    @XmlBinding(path="cookie-http-only")
    @Documentation(content="Marks the session cookie as \"HttpOnly\".")
    public static final ValueProperty PROP_COOKIE_HTTP_ONLY = new ValueProperty(TYPE, "CookieHttpOnly");
    @Type(base=Boolean.class)
    @XmlBinding(path="debug-enabled")
    @Label(standard="enable debug")
    @DefaultValue(text="false")
    @Documentation(content="Enables the debugging feature for HTTP sessions.")
    public static final ValueProperty PROP_DEBUG_ENABLED = new ValueProperty(TYPE, "DebugEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="encode-session-id-in-query-params")
    @Label(standard="encode session ID using query params")
    @DefaultValue(text="false")
    @Documentation(content="The latest servlet specification requires containers to encode the session ID in path parameters. Certain Web servers do not work well with path parameters. In such cases, the \"encode-session-id-in-query-params\" element should be set to \"true\".")
    public static final ValueProperty PROP_ENCODE_SESSION_ID_IN_QUERY_PARAMS = new ValueProperty(TYPE, "EncodeSessionIdInQueryParams");
    @Type(base=Boolean.class)
    @XmlBinding(path="http-proxy-caching-of-cookies")
    @Label(standard="enable HTTP proxy caching of cookies")
    @DefaultValue(text="true")
    @Documentation(content="When set to false, Oracle WebLogic Server adds the following header with the following response:[pbr/]\u201cCache-control: no-cache=set-cookie\u201d[pbr/]This indicates that the proxy caches do not cache the cookies.")
    public static final ValueProperty PROP_HTTP_PROXY_CACHING_OF_COOKIES = new ValueProperty(TYPE, "HttpProxyCachingOfCookies");
    @Type(base=Integer.class)
    @XmlBinding(path="id-length")
    @Label(standard="session ID length (bytes)")
    @DefaultValue(text="52")
    @NumericRange(min="8")
    @Documentation(content="Sets the size of the session ID.[pbr/]The minimum value is 8 bytes, and the maximum value is Integer.MAX_VALUE.[pbr/]If you are writing a WAP application, you must use URL rewriting because the WAP protocol does not support cookies. Also, some WAP devices have a 128-character limit on URL length (including attributes), which limits the amount of data that can be transmitted using URL rewriting. To allow more space for attributes, use this attribute to limit the size of the session ID that is randomly generated by Oracle WebLogic Server.[pbr/]You can also limit the length to a fixed 52 characters, as well as disallow special characters, by setting the \"WAPEnabled\" attribute. For more information, see URL Rewriting and Wireless Access Protocol in Developing Web Applications for WebLogic Server.")
    public static final ValueProperty PROP_ID_LENGTH = new ValueProperty(TYPE, "IdLength");
    @Type(base=Integer.class)
    @XmlBinding(path="invalidation-interval-secs")
    @Label(standard="cleanup interval (secs)")
    @DefaultValue(text="60")
    @NumericRange(min="1")
    @Documentation(content="Sets the time, in seconds, that Oracle WebLogic Server waits between doing house-cleaning checks for timed-out and invalid sessions, and deleting the old sessions and freeing up memory. Use this element to tune Oracle WebLogic Server for best performance on high-traffic sites.[pbr/]The default value is 60 seconds.")
    public static final ValueProperty PROP_INVALIDATION_INTERVAL_SECS = new ValueProperty(TYPE, "InvalidationIntervalSecs");
    @Type(base=Integer.class)
    @XmlBinding(path="max-save-post-size")
    @Label(standard="max save post size (bytes)")
    @DefaultValue(text="4096")
    @NumericRange(min="0")
    @Since(value="12.1.2")
    @Documentation(content="The maximum size in bytes of the POST which will be saved/buffered by the container during FORM authentication")
    public static final ValueProperty PROP_MAX_SAVE_POST_SIZE = new ValueProperty(TYPE, "MaxSavePostSize");
    @Type(base=Integer.class)
    @XmlBinding(path="save-post-timeout-secs")
    @Label(standard="save post timeout (secs)")
    @DefaultValue(text="40")
    @NumericRange(min="0")
    @Since(value="12.1.2")
    @Documentation(content="For FORM authentication the POST is saved in session while the user is re-directed to the login form. This element defines the timeout in seconds for the session which save/buff Post data")
    public static final ValueProperty PROP_SAVE_POST_TIMEOUT_SECS = new ValueProperty(TYPE, "SavePostTimeoutSecs");
    @Type(base=Integer.class)
    @XmlBinding(path="save-post-timeout-interval-secs")
    @Label(standard="save post interval (sec)")
    @DefaultValue(text="20")
    @NumericRange(min="0")
    @Since(value="12.1.2")
    @Documentation(content="Specify the invalidation trigger interval in seconds for save post session.")
    public static final ValueProperty PROP_SAVE_POST_TIMEOUT_INTERVAL_SECS = new ValueProperty(TYPE, "SavePostTimeoutIntervalSecs");
    @XmlBinding(path="jdbc-column-name-max-inactive-interval")
    @Enablement(expr="${ PersistentStoreType == 'jdbc' || PersistentStoreType == 'async_jdbc' }")
    @Label(standard="alt column name")
    @Documentation(content="Serves as an alternative name for the \"wl_max_inactive_interval\" column name. This \"jdbc-column-name-max-inactive-interval\" element applies only to JDBC-based persistence. It is required for certain databases that do not support long column names.")
    public static final ValueProperty PROP_JDBC_COLUMN_NAME_MAX_INACTIVE_INTERVAL = new ValueProperty(TYPE, "JdbcColumnNameMaxInactiveInterval");
    @Type(base=Integer.class)
    @XmlBinding(path="jdbc-connection-timeout-secs")
    @DefaultValue(text="120")
    @NumericRange(min="1")
    @VersionCompatibility(value="12.1.2)")
    @Documentation(content="Note: This item is deprecated in this release.[pbr/]Sets the time, in seconds, that Oracle WebLogic Server waits before timing out a JDBC connection, where x is the number of seconds between.")
    public static final ValueProperty PROP_JDBC_CONNECTION_TIMEOUT_SECS = new ValueProperty(TYPE, "JdbcConnectionTimeoutSecs");
    @XmlBinding(path="monitoring-attribute-name")
    @Label(standard="monitoring attribute")
    @Documentation(content="You use it for tagging session run-time information for different sessions. For example, you can set it to \"username\", if you have a \"username\" attribute which is guaranteed to be unique.[pbr/]Use this element for the following:[pbr/]1. In the WebAppComponentRuntimeBean.getSessionIds() method. If this attribute is set, the method returns an array of session attributes values with this name. If this attribute is not set, then the method returns an array of randomly generated Strings, which is not the same as session IDs for security reasons.[pbr/]2. In the deprecated ServletSessionRuntimeMBean. The getMainAttribute() method of the ServletSessionRuntimeMBean returns the session attribute value using this String as a key.")
    public static final ValueProperty PROP_MONITORING_ATTRIBUTE_NAME = new ValueProperty(TYPE, "MonitoringAttributeName");
    @NamedValues(arbitraryValueLabel="max number of sessions", defaultArbitraryValue="1000", namedValues={@NamedValues.NamedValue(value="-1", label="unlimited")})
    @Type(base=Integer.class)
    @Label(standard="maximum number of in-memory sessions")
    @DefaultValue(text="-1")
    @NumericRange(min="-1")
    @XmlBinding(path="max-in-memory-sessions")
    @Documentation(content="Sets the maximum limit for memory/replicated sessions.[pbr/]Without the ability to configure bound in-memory servlet session use, as new sessions are continually created, the server eventually throws out of memory. To protect against this, Oracle WebLogic Server provides a configurable bound on the number of sessions created. When this number is exceeded, the \"weblogic.servlet.SessionCreationException\" occurs for each attempt to create a new session. This feature applies to both replicated and non-replicated in-memory sessions.[pbr/]To configure bound in-memory servlet session use, you set the limitation in the \"max-in-memory-sessions\" element.")
    public static final ValueProperty PROP_MAX_IN_MEMORY_SESSIONS = new ValueProperty(TYPE, "MaxInMemorySessions");
    @Type(base=Integer.class)
    @XmlBinding(path="persistent-async-queue-timeout")
    @Enablement(expr="${ PersistentStoreType == 'async_jdbc' }")
    @Label(standard="queue timeout")
    @DefaultValue(text="30")
    @NumericRange(min="1")
    public static final ValueProperty PROP_PERSISTENT_ASYNC_QUEUE_TIMEOUT = new ValueProperty(TYPE, "PersistentAsyncQueueTimeout");
    @XmlBinding(path="persistent-data-source-jndi-name")
    @Enablement(expr="${ PersistentStoreType == 'jdbc' || PersistentStoreType == 'async_jdbc' }")
    @Label(standard="DS JNDI name")
    public static final ValueProperty PROP_PERSISTENT_DATA_SOURCE_JNDI_NAME = new ValueProperty(TYPE, "PersistentDataSourceJndiName");
    @Type(base=Integer.class)
    @XmlBinding(path="persistent-session-flush-interval")
    @Enablement(expr="${ PersistentStoreType == 'async_jdbc' }")
    @Label(standard="flush interval")
    @DefaultValue(text="180")
    @NumericRange(min="1")
    public static final ValueProperty PROP_PERSISTENT_SESSION_FLUSH_INTERVAL = new ValueProperty(TYPE, "PersistentSessionFlushInterval");
    @Type(base=Integer.class)
    @XmlBinding(path="persistent-session-flush-threshold")
    @Enablement(expr="${ PersistentStoreType == 'async_jdbc' }")
    @Label(standard="flush threshold")
    @DefaultValue(text="100")
    @NumericRange(min="1")
    public static final ValueProperty PROP_PERSISTENT_SESSION_FLUSH_THRESHOLD = new ValueProperty(TYPE, "PersistentSessionFlushThreshold");
    @XmlBinding(path="persistent-store-cookie-name")
    @Enablement(expr="${ PersistentStoreType == 'cookie' }")
    @Label(standard="PS cookie name")
    @DefaultValue(text="WLCOOKIE")
    @Documentation(content="Sets the name of the cookie used for cookie-based persistence. The WLCOOKIE cookie carries the session state, which should not be shared between Web applications.[pbr/]For more information, see Using Cookie-Based Session Persistence.")
    public static final ValueProperty PROP_PERSISTENT_STORE_COOKIE_NAME = new ValueProperty(TYPE, "PersistentStoreCookieName");
    @XmlBinding(path="persistent-store-dir")
    @Enablement(expr="${ PersistentStoreType == 'file' }")
    @Label(standard="PS directory")
    @DefaultValue(text="session_db")
    @Documentation(content="Specifies the storage directory used for file-based persistence.[pbr/]Ensure that you have enough disk space to store the number of valid sessions multiplied by the size of each session. You can find the size of a session by looking at the files created in the \"persistent-store-dir\". Note that the size of each session can vary as the size of serialized session data changes.[pbr/]Each server instance has a default persistent file store that requires no configuration. Therefore, if no directory is specified, a default store is automatically created in the [server-name]\\data\\store\\default directory. However, the default store is not shareable among clustered servers.[pbr/]You can make file-persistent sessions clusterable by creating a custom persistent store in a directory that is shared among different servers. However, this requires you to create this directory manually.")
    public static final ValueProperty PROP_PERSISTENT_STORE_DIR = new ValueProperty(TYPE, "PersistentStoreDir");
    @XmlBinding(path="persistent-store-pool")
    @Enablement(expr="${ PersistentStoreType == 'jdbc' || PersistentStoreType == 'async_jdbc' }")
    @Label(standard="JDBC pool")
    @Documentation(content="Specifies the name of a JDBC connection pool to be used for persistence storage.")
    public static final ValueProperty PROP_PERSISTENT_STORE_POOL = new ValueProperty(TYPE, "PersistentStorePool");
    @XmlBinding(path="persistent-store-table")
    @Enablement(expr="${ PersistentStoreType == 'jdbc' || PersistentStoreType == 'async_jdbc' }")
    @Label(standard="table name")
    @DefaultValue(text="wl_servlet_sessions")
    @Documentation(content="Specifies the database table name used to store JDBC-based persistent sessions. This applies only when \"persistent-store-type\" is set to \"jdbc\".[pbr/]The \"persistent-store-table\" element is used when you choose a database table name other than the default.")
    public static final ValueProperty PROP_PERSISTENT_STORE_TABLE = new ValueProperty(TYPE, "PersistentStoreTable");
    @Type(base=PersistentStoreType.class)
    @XmlBinding(path="persistent-store-type")
    @Label(standard="store type")
    @DefaultValue(text="memory")
    @Service(impl=PersistentStoreTypeValidator.class)
    @Documentation(content="Sets the persistent store method to one of the following options:[ul][li]Memory : Use memory to store session data. This effectively disables persistent session storage.[/li][li]File : Use the file system on the server to store session data.[/li][li]Replicated : Use memory to store session data, but replicate across the clustered servers.[/li][li]Asynchronously Replicated : Use \"Replicated\" method if deployed on a clustered server, otherwise use \"Memory\" method.[/li][li]Replicated If Clustered : Use memory to store session data, but replicate across the clustered servers. Replication happens in the background.[/li][li]Asynchronously Replicated If Clustered : Use \"Asynchronously Replicated\" method if deployed on a clustered server, otherwise use \"Memory\" method.[/li][li]JDBC : Use a database to store session data.[/li][li]Asynchronous JDBC : Use a database to store session data. Database is updated in the background.[/li][li]Cookie : Use a cookie in user's browser to store session data.[/li][li]Coherence*Web : Use Coherence to store session data. The Coherence*Web library must be made available to the application to use this feature.[/li][/ul]")
    public static final ValueProperty PROP_PERSISTENT_STORE_TYPE = new ValueProperty(TYPE, "PersistentStoreType");
    @Type(base=Boolean.class)
    @XmlBinding(path="sharing-enabled")
    @Label(standard="enable session sharing")
    @DefaultValue(text="false")
    @Documentation(content="Enables Web applications to share HTTP sessions when the value is set to true at the application level.[pbr/]This element is ignored if turned on at the Web application level.")
    public static final ValueProperty PROP_SHARING_ENABLED = new ValueProperty(TYPE, "SharingEnabled");
    @Type(base=Integer.class)
    @XmlBinding(path="timeout-secs")
    @Label(standard="session timeout (secs)")
    @DefaultValue(text="3600")
    @NumericRange(min="1")
    @Documentation(content="Sets the time, in seconds, that Oracle WebLogic Server waits before timing out a session. [pbr/]Note that on busy sites, you can tune your application by adjusting the timeout of sessions. While you want to give a browser client every opportunity to finish a session, you do not want to tie up the server needlessly if the user has left the site or otherwise abandoned the session.[pbr/]This element can be overridden by the \"session-timeout\" element (defined in minutes) in the web.xml file.[pbr/]The default value is 3600 seconds.")
    public static final ValueProperty PROP_TIMEOUT_SECS = new ValueProperty(TYPE, "TimeoutSecs");
    @Type(base=Boolean.class)
    @XmlBinding(path="tracking-enabled")
    @Label(standard="enable session tracking")
    @DefaultValue(text="true")
    @Documentation(content="Enables session tracking between HTTP requests.")
    public static final ValueProperty PROP_TRACKING_ENABLED = new ValueProperty(TYPE, "TrackingEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="url-rewriting-enabled")
    @Label(standard="enable URL rewriting for session tracking")
    @DefaultValue(text="true")
    @Documentation(content="Enables URL rewriting, which encodes the session ID into the URL and provides session tracking if cookies are disabled in the browser.")
    public static final ValueProperty PROP_URL_REWRITING_ENABLED = new ValueProperty(TYPE, "UrlRewritingEnabled");
    @Type(base=Boolean.class)
    @Label(standard="invalidate on re-login")
    @XmlBinding(path="invalidate-on-relogin")
    @DefaultValue(text="false")
    @Since(value="10.3.6")
    @Documentation(content="Indicates whether or not the container should invalidate the current session when the current logged in user switches to another user. If the flag is set to true, the current session will be invalidated once the current user logs in as a different security user.")
    public static final ValueProperty PROP_INVALIDATE_ON_RELOGIN = new ValueProperty(TYPE, "InvalidateOnRelogin");

    public Value<Integer> getCacheSize();

    public void setCacheSize(String var1);

    public void setCacheSize(Integer var1);

    public Value<String> getCookieComment();

    public void setCookieComment(String var1);

    public Value<String> getCookieDomain();

    public void setCookieDomain(String var1);

    public Value<Integer> getCookieMaxAgeSecs();

    public void setCookieMaxAgeSecs(String var1);

    public void setCookieMaxAgeSecs(Integer var1);

    public Value<String> getCookieName();

    public void setCookieName(String var1);

    public Value<String> getCookiePath();

    public void setCookiePath(String var1);

    public Value<Boolean> isCookieSecure();

    public void setCookieSecure(String var1);

    public void setCookieSecure(Boolean var1);

    public Value<Boolean> isCookiesEnabled();

    public void setCookiesEnabled(String var1);

    public void setCookiesEnabled(Boolean var1);

    public Value<Boolean> isCookieHttpOnly();

    public void setCookieHttpOnly(String var1);

    public void setCookieHttpOnly(Boolean var1);

    public Value<Boolean> isDebugEnabled();

    public void setDebugEnabled(String var1);

    public void setDebugEnabled(Boolean var1);

    public Value<Boolean> isEncodeSessionIdInQueryParams();

    public void setEncodeSessionIdInQueryParams(String var1);

    public void setEncodeSessionIdInQueryParams(Boolean var1);

    public Value<Boolean> isHttpProxyCachingOfCookies();

    public void setHttpProxyCachingOfCookies(String var1);

    public void setHttpProxyCachingOfCookies(Boolean var1);

    public Value<Integer> getIdLength();

    public void setIdLength(String var1);

    public void setIdLength(Integer var1);

    public Value<Integer> getInvalidationIntervalSecs();

    public void setInvalidationIntervalSecs(String var1);

    public void setInvalidationIntervalSecs(Integer var1);

    public Value<Integer> getMaxSavePostSize();

    public void setMaxSavePostSize(String var1);

    public void setMaxSavePostSize(Integer var1);

    public Value<Integer> getSavePostTimeoutSecs();

    public void setSavePostTimeoutSecs(String var1);

    public void setSavePostTimeoutSecs(Integer var1);

    public Value<Integer> getSavePostTimeoutIntervalSecs();

    public void setSavePostTimeoutIntervalSecs(String var1);

    public void setSavePostTimeoutIntervalSecs(Integer var1);

    public Value<String> getJdbcColumnNameMaxInactiveInterval();

    public void setJdbcColumnNameMaxInactiveInterval(String var1);

    public Value<Integer> getJdbcConnectionTimeoutSecs();

    public void setJdbcConnectionTimeoutSecs(String var1);

    public void setJdbcConnectionTimeoutSecs(Integer var1);

    public Value<String> getMonitoringAttributeName();

    public void setMonitoringAttributeName(String var1);

    public Value<Integer> getMaxInMemorySessions();

    public void setMaxInMemorySessions(String var1);

    public void setMaxInMemorySessions(Integer var1);

    public Value<Integer> getPersistentAsyncQueueTimeout();

    public void setPersistentAsyncQueueTimeout(String var1);

    public void setPersistentAsyncQueueTimeout(Integer var1);

    public Value<String> getPersistentDataSourceJndiName();

    public void setPersistentDataSourceJndiName(String var1);

    public Value<Integer> getPersistentSessionFlushInterval();

    public void setPersistentSessionFlushInterval(String var1);

    public void setPersistentSessionFlushInterval(Integer var1);

    public Value<Integer> getPersistentSessionFlushThreshold();

    public void setPersistentSessionFlushThreshold(String var1);

    public void setPersistentSessionFlushThreshold(Integer var1);

    public Value<String> getPersistentStoreCookieName();

    public void setPersistentStoreCookieName(String var1);

    public Value<String> getPersistentStoreDir();

    public void setPersistentStoreDir(String var1);

    public Value<String> getPersistentStorePool();

    public void setPersistentStorePool(String var1);

    public Value<String> getPersistentStoreTable();

    public void setPersistentStoreTable(String var1);

    public Value<PersistentStoreType> getPersistentStoreType();

    public void setPersistentStoreType(String var1);

    public void setPersistentStoreType(PersistentStoreType var1);

    public Value<Boolean> isSharingEnabled();

    public void setSharingEnabled(String var1);

    public void setSharingEnabled(Boolean var1);

    public Value<Integer> getTimeoutSecs();

    public void setTimeoutSecs(String var1);

    public void setTimeoutSecs(Integer var1);

    public Value<Boolean> isTrackingEnabled();

    public void setTrackingEnabled(String var1);

    public void setTrackingEnabled(Boolean var1);

    public Value<Boolean> isUrlRewritingEnabled();

    public void setUrlRewritingEnabled(String var1);

    public void setUrlRewritingEnabled(Boolean var1);

    public Value<Boolean> getInvalidateOnRelogin();

    public void setInvalidateOnRelogin(String var1);

    public void setInvalidateOnRelogin(Boolean var1);
}

