/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.ComponentContentRelativePathService;
import oracle.eclipse.tools.weblogic.descriptors.ModuleType;
import oracle.eclipse.tools.weblogic.descriptors.internal.GARModuleProviderImpl;
import oracle.eclipse.tools.weblogic.descriptors.internal.ModuleTypeValidator;
import oracle.eclipse.tools.weblogic.descriptors.internal.ModuleTypeValueChangeListener;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Listeners;
import org.eclipse.sapphire.modeling.annotations.NoDuplicates;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="module")
public interface IModuleDefinition
extends Element {
    public static final ElementType TYPE = new ElementType(IModuleDefinition.class);
    @XmlBinding(path="name")
    @Label(standard="name")
    @Required
    @NoDuplicates
    @Documentation(content="Describes a single JMS, JDBC, GAR or Interception module. Each module definition has a name, a type, and a path. Module path is treated relative to the root of the Enterprise application and should point to the XML file that defines the module.")
    public static final ValueProperty PROP_NAME = new ValueProperty(TYPE, "Name");
    @Type(base=ModuleType.class)
    @XmlBinding(path="type")
    @Label(standard="type")
    @Required
    @Service(impl=ModuleTypeValidator.class)
    @Listeners(value={ModuleTypeValueChangeListener.class})
    @Documentation(content="Describes a single JMS, JDBC, GAR or Interception module. Each module definition has a name, a type, and a path. Module path is treated relative to the root of the Enterprise application and should point to the XML file that defines the module.")
    public static final ValueProperty PROP_TYPE = new ValueProperty(TYPE, "Type");
    @Type(base=Path.class)
    @XmlBinding(path="path")
    @Label(standard="path")
    @Required
    @Service(impl=ComponentContentRelativePathService.class)
    @ValidFileSystemResourceType(value=FileSystemResourceType.FILE)
    @Documentation(content="Describes a single JMS, JDBC or Interception module. Each module definition has a name, a type, and a path. Module path is treated relative to the root of the Enterprise application and should point to the XML file that defines the module.")
    public static final ValueProperty PROP_PATH = new ValueProperty(TYPE, "Path");
    @XmlBinding(path="path")
    @Label(standard="path")
    @Required
    @Documentation(content="GAR module path relative to the root of the Enterprise application")
    @Service(impl=GARModuleProviderImpl.class)
    public static final ValueProperty PROP_GAR_PATH = new ValueProperty(TYPE, "GarPath");

    public Value<String> getName();

    public void setName(String var1);

    public Value<ModuleType> getType();

    public void setType(String var1);

    public void setType(ModuleType var1);

    public Value<Path> getPath();

    public void setPath(String var1);

    public void setPath(Path var1);

    public Value<String> getGarPath();

    public void setGarPath(String var1);
}

