/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.common.internal.JavaCharacterEncodingPossibleValuesService;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaPackageName;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IJspDescriptorSection
extends Element {
    public static final ElementType TYPE = new ElementType(IJspDescriptorSection.class);
    @Type(base=Boolean.class)
    @XmlBinding(path="backward-compatible")
    @Label(standard="enable backwards compatibility with WLS 9.2 and earlier")
    @DefaultValue(text="true")
    @Documentation(content="When set to true, backward compatibility is enabled.", topics={@Documentation.Topic(label="Backwards Compatibility Flags", url="http://download.oracle.com/docs/cd/E13222_01/wls/docs103/webapp/weblogic_xml.html#wp1075210")})
    public static final ValueProperty PROP_BACKWARD_COMPATIBLE = new ValueProperty(TYPE, "BackwardCompatible");
    @Type(base=Boolean.class)
    @XmlBinding(path="compress-html-template")
    @Label(standard="compress whitespace in HTML template")
    @DefaultValue(text="false")
    @Since(value="10.3")
    @Documentation(content="When set to \"true\", compresses the HTML in the JSP template blocks to improve run-time performance.[pbr/]Note: If the JSP\u2019s HTML template block contains the <pre> HTML tag, do not enable this feature.")
    public static final ValueProperty PROP_COMPRESS_HTML_TEMPLATE = new ValueProperty(TYPE, "CompressHtmlTemplate");
    @Type(base=Boolean.class)
    @XmlBinding(path="debug")
    @Label(standard="generate all debugging information")
    @DefaultValue(text="false")
    @Documentation(content="If enabled, generates all debugging information including local variables when creating class files. By default, only line number and source file information is generated.")
    public static final ValueProperty PROP_GENERATE_ALL_DEBUGGING_INFORMATION = new ValueProperty(TYPE, "GenerateAllDebuggingInformation");
    @XmlBinding(path="default-file-name")
    @Label(standard="default file name")
    @DefaultValue(text="index.jsp")
    @Documentation(content="The default file name in which Oracle WebLogic Server saves the generated Java and compiled class files for a JSP page.")
    public static final ValueProperty PROP_DEFAULT_FILE_NAME = new ValueProperty(TYPE, "DefaultFileName");
    @XmlBinding(path="encoding")
    @Label(standard="default character encoding")
    @Service(impl=JavaCharacterEncodingPossibleValuesService.class)
    @Documentation(content="Specifies the default character set used in the JSP page. Use standard Java character set names.[pbr/]If not set, this attribute defaults to the encoding for your platform.[pbr/]A JSP page directive (included in the JSP code) overrides this setting. For example:[pbr/]<%@ page contentType=\"text/html; charset=custom-encoding\"%>", topics={@Documentation.Topic(label="Supported Encodings", url="http://java.sun.com/j2se/1.5.0/docs/guide/intl/encoding.doc.html")})
    public static final ValueProperty PROP_ENCODING = new ValueProperty(TYPE, "Encoding");
    @Type(base=Boolean.class)
    @XmlBinding(path="exact-mapping")
    @Label(standard="enable exact mapping of JspStub to request")
    @DefaultValue(text="true")
    @Documentation(content="When set to \"true\", upon the first request for a JSP page the newly created JspStub is mapped to the exact request. If \"exactMapping\" is set to \"false\", the Web application container generates non-exact URL mapping for JSP. \"exactMapping\" allows path info for JSP.")
    public static final ValueProperty PROP_EXACT_MAPPING = new ValueProperty(TYPE, "ExactMapping");
    @Type(base=Boolean.class)
    @XmlBinding(path="keepgenerated")
    @Label(standard="keep generated Java files")
    @DefaultValue(text="false")
    @Documentation(content="Saves the Java files that are generated as an intermediary step in the JSP compilation process. Unless this parameter is set to \"true\", the intermediate Java files are deleted after they are compiled.")
    public static final ValueProperty PROP_KEEP_GENERATED = new ValueProperty(TYPE, "KeepGenerated");
    @Type(base=Boolean.class)
    @XmlBinding(path="optimize-java-expression")
    @Label(standard="optimize Java expressions")
    @DefaultValue(text="false")
    @Since(value="10.3")
    @Documentation(content="When set to \"true\", the JSP compiler optimizes Java expressions to improve run-time performance.")
    public static final ValueProperty PROP_OPTIMIZE_JAVA_EXPRESSION = new ValueProperty(TYPE, "OptimizeJavaExpression");
    @Type(base=JavaPackageName.class)
    @XmlBinding(path="package-prefix")
    @Label(standard="package prefix")
    @DefaultValue(text="jsp_servlet")
    @Documentation(content="Specifies the package prefix into which all JSP pages are compiled.")
    public static final ValueProperty PROP_PACKAGE_PREFIX = new ValueProperty(TYPE, "PackagePrefix");
    @NamedValues(arbitraryValueLabel="check JSPs at specified interval", defaultArbitraryValue="1", namedValues={@NamedValues.NamedValue(value="-1", label="never check JSPs"), @NamedValues.NamedValue(value="0", label="constantly check JSPs")})
    @Type(base=Integer.class)
    @Label(standard="interval (in seconds) to check JSPs for changes to trigger recompilation")
    @DefaultValue(text="1")
    @NumericRange(min="-1")
    @XmlBinding(path="page-check-seconds")
    @Documentation(content="Sets the interval, in seconds, at which Oracle WebLogic Server checks if JSP files have changed and need recompiling. Dependencies are also checked and recursively reloaded if changes detected.[pbr/]The value -1 means never check the pages. This is the default value in a production environment.[pbr/]The value 0 means always check the pages.[pbr/]The value 1 means check the pages every second. This is the default value in a development environment.[pbr/]In a production environment, where changes to a JSP are rare, consider changing the value of \"pageCheckSeconds\" to 60 or greater, according to your tuning requirements.")
    public static final ValueProperty PROP_PAGE_CHECK_SECONDS = new ValueProperty(TYPE, "PageCheckSeconds");
    @Type(base=Boolean.class)
    @XmlBinding(path="precompile")
    @Label(standard="precompile JSPs")
    @DefaultValue(text="false")
    @Documentation(content="When set to true, Oracle WebLogic Server automatically precompiles all modified JSP when the Web application is deployed or redeployed, or when starting Oracle WebLogic Server.")
    public static final ValueProperty PROP_PRECOMPILE = new ValueProperty(TYPE, "Precompile");
    @Type(base=Boolean.class)
    @XmlBinding(path="precompile-continue")
    @Label(standard="continue precompiling JSPs when encountering an error")
    @DefaultValue(text="false")
    @Documentation(content="When set to true, Oracle WebLogic Server continues precompiling all modified JSP even if some of those JSP fail during compilation. Only takes effect when \"precompile\" is set to \"true\".")
    public static final ValueProperty PROP_PRECOMPILE_CONTINUE = new ValueProperty(TYPE, "PrecompileContinue");
    @Type(base=Boolean.class)
    @XmlBinding(path="print-nulls")
    @Label(standard="print nulls")
    @DefaultValue(text="true")
    @Documentation(content="When set to \"false\", this parameter ensures that expressions with \"null\" results are printed as \" \".")
    public static final ValueProperty PROP_PRINT_NULLS = new ValueProperty(TYPE, "PrintNulls");
    @Type(base=Boolean.class)
    @XmlBinding(path="rtexprvalue-jsp-param-name")
    @Label(standard="allow runtime expressions in param tag name attribute")
    @DefaultValue(text="false")
    @Documentation(content="Allows run-time expression values in the name attribute of the \"jsp:param\" tag.")
    public static final ValueProperty PROP_RTEXPRVALUE_JSP_PARAM_NAME = new ValueProperty(TYPE, "RtexprvalueJspParamName");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @XmlBinding(path="super-class")
    @Label(standard="superclass")
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS})
    @Documentation(content="The superclass to be used for the generated JSP classes.")
    public static final ValueProperty PROP_SUPER_CLASS = new ValueProperty(TYPE, "SuperClass");
    @Type(base=Boolean.class)
    @XmlBinding(path="verbose")
    @Label(standard="print debug information")
    @DefaultValue(text="true")
    @Documentation(content="When set to \"true\", debugging information is printed out to the browser, the command prompt, and Oracle WebLogic Server log file.")
    public static final ValueProperty PROP_VERBOSE = new ValueProperty(TYPE, "Verbose");
    @XmlBinding(path="working-dir")
    @Label(standard="working directory")
    @Documentation(content="The name of a directory where Oracle WebLogic Server saves the generated Java and compiled class files for a JSP page.")
    public static final ValueProperty PROP_WORKING_DIR = new ValueProperty(TYPE, "WorkingDir");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @XmlBinding(path="resource-provider-class")
    @Label(standard="resource provider")
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"oracle.jsp.provider.JspResourceProvider"})
    @MustExist
    @Since(value="10.3")
    @Documentation(content="Used for specifying custom logic for looking up JSP resources. When a resource provider is configured, the Web container will query the resource provider for all resource requests mapped to the JSP servlet. By default, all requests to *.jsp(x) are mapped to the JSP servlet. Additional extensions can be mapped by using the \"jsp-config\" element in the web.xml descriptor.")
    public static final ValueProperty PROP_RESOURCE_PROVIDER_CLASS = new ValueProperty(TYPE, "ResourceProviderClass");
    @Type(base=Boolean.class)
    @Label(standard="use strict stale check")
    @XmlBinding(path="strict-stale-check")
    @DefaultValue(text="false")
    @Since(value="10.3.6")
    @Documentation(content="Instructs the compiler to use != operator to compare the timestamp during stale check for exploded archive.")
    public static final ValueProperty PROP_USE_STRICT_STALE_CHECK = new ValueProperty(TYPE, "UseStrictStaleCheck");

    public Value<Boolean> isBackwardCompatible();

    public void setBackwardCompatible(String var1);

    public void setBackwardCompatible(Boolean var1);

    public Value<Boolean> isCompressHtmlTemplate();

    public void setCompressHtmlTemplate(String var1);

    public void setCompressHtmlTemplate(Boolean var1);

    public Value<Boolean> isGenerateAllDebuggingInformation();

    public void setGenerateAllDebuggingInformation(String var1);

    public void setGenerateAllDebuggingInformation(Boolean var1);

    public Value<String> getDefaultFileName();

    public void setDefaultFileName(String var1);

    public Value<String> getEncoding();

    public void setEncoding(String var1);

    public Value<Boolean> isExactMapping();

    public void setExactMapping(String var1);

    public void setExactMapping(Boolean var1);

    public Value<Boolean> isKeepGenerated();

    public void setKeepGenerated(String var1);

    public void setKeepGenerated(Boolean var1);

    public Value<Boolean> isOptimizeJavaExpression();

    public void setOptimizeJavaExpression(String var1);

    public void setOptimizeJavaExpression(Boolean var1);

    public Value<JavaPackageName> getPackagePrefix();

    public void setPackagePrefix(String var1);

    public void setPackagePrefix(JavaPackageName var1);

    public Value<Integer> getPageCheckSeconds();

    public void setPageCheckSeconds(String var1);

    public void setPageCheckSeconds(Integer var1);

    public Value<Boolean> isPrecompile();

    public void setPrecompile(String var1);

    public void setPrecompile(Boolean var1);

    public Value<Boolean> isPrecompileContinue();

    public void setPrecompileContinue(String var1);

    public void setPrecompileContinue(Boolean var1);

    public Value<Boolean> isPrintNulls();

    public void setPrintNulls(String var1);

    public void setPrintNulls(Boolean var1);

    public Value<Boolean> isRtexprvalueJspParamName();

    public void setRtexprvalueJspParamName(String var1);

    public void setRtexprvalueJspParamName(Boolean var1);

    public ReferenceValue<JavaTypeName, JavaType> getSuperClass();

    public void setSuperClass(String var1);

    public void setSuperClass(JavaTypeName var1);

    public Value<Boolean> isVerbose();

    public void setVerbose(String var1);

    public void setVerbose(Boolean var1);

    public Value<String> getWorkingDir();

    public void setWorkingDir(String var1);

    public ReferenceValue<JavaTypeName, JavaType> getResourceProviderClass();

    public void setResourceProviderClass(String var1);

    public void setResourceProviderClass(JavaTypeName var1);

    public Value<Boolean> getUseStrictStaleCheck();

    public void setUseStrictStaleCheck(String var1);

    public void setUseStrictStaleCheck(Boolean var1);
}

