/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import oracle.eclipse.tools.weblogic.descriptors.EntityCacheSizeUnits;
import oracle.eclipse.tools.weblogic.descriptors.EntityCachingStrategy;
import oracle.eclipse.tools.weblogic.descriptors.app.internal.EntityCacheMaxCacheSizeBinding;
import oracle.eclipse.tools.weblogic.descriptors.app.internal.EntityCacheMaxCacheSizeUnitsBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NoDuplicates;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="entity cache")
public interface IEntityCache
extends Element {
    public static final ElementType TYPE = new ElementType(IEntityCache.class);
    @Label(standard="name")
    @Required
    @NoDuplicates
    @XmlBinding(path="entity-cache-name")
    @Documentation(content="Specifies a unique name for an entity bean cache. The name must be unique within an EAR file and may not be an empty String.")
    public static final ValueProperty PROP_NAME = new ValueProperty(TYPE, "Name");
    @Type(base=EntityCachingStrategy.class)
    @Label(standard="caching strategy ")
    @DefaultValue(text="MultiVersion")
    @XmlBinding(path="caching-strategy")
    @Documentation(content="Specifies the general strategy that the EJB container uses to manage entity bean instances in a particular application-level cache. A cache buffers entity bean instances in memory and associates them with their primary key value.[pbr/]There are two available caching strategies:[ul][li]Exclusive: caches a single bean instance in memory for each primary key value. This unique instance is typically locked using the EJB container\u2019s exclusive locking when it is in use, so that only one transaction can use the instance at a time.[/li][li]MultiVersion: caches multiple bean instances in memory for a given primary key value. Each instance can be used by a different transaction concurrently.[/li][/ul]")
    public static final ValueProperty PROP_CACHING_STRATEGY = new ValueProperty(TYPE, "CachingStrategy");
    @Type(base=Integer.class)
    @Label(standard="maximum SQL queries")
    @XmlBinding(path="max-queries-in-cache")
    @NumericRange(min="0")
    @DefaultValue(text="100")
    @Documentation(content="Specifies the maximum SQL queries that can be present in the entity cache at a given moment.")
    public static final ValueProperty PROP_MAX_QUERIES_IN_CACHE = new ValueProperty(TYPE, "MaxQueriesInCache");
    @Type(base=Integer.class)
    @Label(standard="maximum cache size")
    @DefaultValue(text="1000")
    @NumericRange(min="1")
    @CustomXmlValueBinding(impl=EntityCacheMaxCacheSizeBinding.class)
    @Documentation(content="Specifies a limit on the size of an entity cache in terms of memory footprint (expressed either in bytes or megabytes), or in terms of the number of beans. If specified in terms of memory footprint, the bean provider should provide an estimate of the average size of a bean in the weblogic-ejb-jar.xml descriptor. By default, a bean is assumed to have an average size of 100 bytes.")
    public static final ValueProperty PROP_MAX_CACHE_SIZE = new ValueProperty(TYPE, "MaxCacheSize");
    @Type(base=EntityCacheSizeUnits.class)
    @Label(standard="maximum cache size units")
    @DefaultValue(text="BEANS")
    @CustomXmlValueBinding(impl=EntityCacheMaxCacheSizeUnitsBinding.class)
    @Documentation(content="Specifies the units used for setting the maximum entity cache size. Max entity cache size can be specified in terms of memory footprint (expressed either in bytes or megabytes) or in terms of the number of beans. If specified in terms of memory footprint, the bean provider should provide an estimate of the average size of a bean in the weblogic-ejb-jar.xml descriptor. By default, a bean is assumed to have an average size of 100 bytes.")
    public static final ValueProperty PROP_MAX_CACHE_SIZE_UNITS = new ValueProperty(TYPE, "MaxCacheSizeUnits");

    public Value<String> getName();

    public void setName(String var1);

    public Value<EntityCachingStrategy> getCachingStrategy();

    public void setCachingStrategy(String var1);

    public void setCachingStrategy(EntityCachingStrategy var1);

    public Value<Integer> getMaxQueriesInCache();

    public void setMaxQueriesInCache(String var1);

    public void setMaxQueriesInCache(Integer var1);

    public Value<Integer> getMaxCacheSize();

    public void setMaxCacheSize(String var1);

    public void setMaxCacheSize(Integer var1);

    public Value<EntityCacheSizeUnits> getMaxCacheSizeUnits();

    public void setMaxCacheSizeUnits(String var1);

    public void setMaxCacheSizeUnits(EntityCacheSizeUnits var1);
}

