/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.LongString;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IDatabaseConnectionTestingProperties
extends Element {
    public static final ElementType TYPE = new ElementType(IDatabaseConnectionTestingProperties.class);
    @XmlBinding(path="table-name")
    @Label(standard="table name")
    @Documentation(content="The name of the table used when testing a physical database connection. The default SQL code used to test a connection is the following:[pbr/]\"select count(*) from TestTableName\"[pbr/]The TestTableName must exist and be accessible to the database user for the connection. Most database servers optimize this SQL to avoid a table scan, but it is still a good idea to set TestTableName to the name of a table that is known to have few rows, or even no rows.[pbr/]If TestTableName begins with \"SQL\", then the rest of the string following that leading token will be taken as a literal SQL statement that will be used to test a connection.")
    public static final ValueProperty PROP_TABLE_NAME = new ValueProperty(TYPE, "TableName");
    @Type(base=Boolean.class)
    @XmlBinding(path="check-on-create-enabled")
    @Label(standard="test connection when created")
    @DefaultValue(text="false")
    @Documentation(content="If enabled, then the connection will be tested when it is created.")
    public static final ValueProperty PROP_TEST_ON_CREATE_ENABLED = new ValueProperty(TYPE, "TestOnCreateEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="check-on-reserve-enabled")
    @Label(standard="test connection when reserved")
    @DefaultValue(text="false")
    @Documentation(content="If enabled, then the connection will be tested each time before it is handed out to a user.")
    public static final ValueProperty PROP_TEST_ON_RESERVE_ENABLED = new ValueProperty(TYPE, "TestOnReserveEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="check-on-release-enabled")
    @Label(standard="test connection when released")
    @DefaultValue(text="false")
    @Documentation(content="If enabled, then the connection will be tested each time a user returns a connection to the pool.")
    public static final ValueProperty PROP_TEST_ON_RELEASE_ENABLED = new ValueProperty(TYPE, "TestOnReleaseEnabled");
    @Type(base=Integer.class)
    @XmlBinding(path="test-frequency-seconds")
    @Label(standard="test frequency (secs)")
    @Documentation(content="The number of seconds between database connection tests. After every specifed interval, unused connectios are tested using the specified table. Connections that do not pass the test will be closed and reopened to reestablish a valid physical database connection. If table name is not set, the test will not be performed.")
    public static final ValueProperty PROP_TEST_FREQUENCY = new ValueProperty(TYPE, "TestFrequency");
    @Type(base=Integer.class)
    @XmlBinding(path="refresh-minutes")
    @Label(standard="test frequency (mins)")
    @Deprecated
    @Documentation(content="The number of minutes between database connection tests. After every specified interval, unused connectios are tested using the specified table. Conections that do not pass the test will be closed and reopened to reestablish a valid physical database connection. If table name is not set, the test will not be performed.")
    public static final ValueProperty PROP_TEST_FREQUENCY_MINUTES = new ValueProperty(TYPE, "TestFrequencyMinutes");
    @Type(base=Integer.class)
    @XmlBinding(path="connection-reserve-timeout-seconds")
    @Label(standard="reserve timeout (secs)")
    @NumericRange(min="-1")
    @DefaultValue(text="-1")
    @Documentation(content="Number of seconds after which the call to reserve a connection from the pool will timeout.")
    public static final ValueProperty PROP_RESERVE_TIMEOUT = new ValueProperty(TYPE, "ReserveTimeout");
    @Type(base=Integer.class)
    @XmlBinding(path="connection-creation-retry-frequency-seconds")
    @Label(standard="creation retry frequency (secs)")
    @Documentation(content="The frequency of the retry attempts by the pool to establish connections to the database.")
    public static final ValueProperty PROP_CREATION_RETRY_FREQUENCY = new ValueProperty(TYPE, "CreationRetryFrequency");
    @Type(base=Integer.class)
    @XmlBinding(path="inactive-connection-timeout-seconds")
    @Label(standard="inactive connection timeout (secs)")
    @Documentation(content="The number of seconds of inactivity after which a reserved connection will be forcibly released back into the pool.")
    public static final ValueProperty PROP_INACTIVE_TIMEOUT = new ValueProperty(TYPE, "InactiveTimeout");
    @XmlBinding(path="init-sql")
    @Label(standard="SQL statement to run when connection is created")
    @LongString
    @Documentation(content="The SQL query that will be executed when a connection is created.")
    public static final ValueProperty PROP_INIT_SQL_STATEMENT = new ValueProperty(TYPE, "InitSqlStatement");

    public Value<String> getTableName();

    public void setTableName(String var1);

    public Value<Boolean> isTestOnCreateEnabled();

    public void setTestOnCreateEnabled(String var1);

    public void setTestOnCreateEnabled(Boolean var1);

    public Value<Boolean> isTestOnReserveEnabled();

    public void setTestOnReserveEnabled(String var1);

    public void setTestOnReserveEnabled(Boolean var1);

    public Value<Boolean> isTestOnReleaseEnabled();

    public void setTestOnReleaseEnabled(String var1);

    public void setTestOnReleaseEnabled(Boolean var1);

    public Value<Integer> getTestFrequency();

    public void setTestFrequency(String var1);

    public void setTestFrequency(Integer var1);

    public Value<Integer> getTestFrequencyMinutes();

    public void setTestFrequencyMinutes(String var1);

    public void setTestFrequencyMinutes(Integer var1);

    public Value<Integer> getReserveTimeout();

    public void setReserveTimeout(String var1);

    public void setReserveTimeout(Integer var1);

    public Value<Integer> getCreationRetryFrequency();

    public void setCreationRetryFrequency(String var1);

    public void setCreationRetryFrequency(Integer var1);

    public Value<Integer> getInactiveTimeout();

    public void setInactiveTimeout(String var1);

    public void setInactiveTimeout(Integer var1);

    public Value<String> getInitSqlStatement();

    public void setInitSqlStatement(String var1);
}

